import dynamic from "next/dynamic";
import { detectDevice, getAppConfiguration } from "@/app/_libs";

import { ThemeProvider } from "@/app/_providers/ThemeProvider";
import { RootQueryClientProvider } from "@/app/_providers/RootQueryClientProvider";
import { ProgressBarProvider } from "@/app/_providers/ProgressBarProvider";
import {
  DeviceContextProvider,
  AuthContextProvider,
  ConfigurationProvider,
} from "@/app/_context";

import { ScrollToTop } from "@/app/_includes";

import "./globals.css";

const SignIn = dynamic(() => import("@/app/_includes/Auth/SignIn"));
const SignUp = dynamic(() => import("@/app/_includes/Auth/SignUp"));
//const StickyAd = dynamic(() => import("@/app/_includes/StickyAd"));
import QuickLink from "./_includes/QuickLink";

/** @type {import("next").Metadata} */
export const metadata = {
  metadataBase: new URL(process.env.APP_BASE_URL),
};

export default async function RootLayout({ children }) {
  const devices = await detectDevice();

  return (
    <html lang="en">
      <body>
        <AuthContextProvider>
          <DeviceContextProvider {...devices}>
            <ProgressBarProvider>
              <ThemeProvider>
                <RootQueryClientProvider>
                  <ConfigurationProvider>
                    {children}

                    {/* Page Scroll To Top Item */}
                    <ScrollToTop />

                    {/* SignIn Component */}
                    <SignIn />

                    {/* SignUp Component */}
                    <SignUp />

                    {/* Sticky Add Component */}
                    {/* <StickyAd /> */}
                    {/* QuickLink Component */}
                    <QuickLink />

                  </ConfigurationProvider>
                </RootQueryClientProvider>
              </ThemeProvider>
            </ProgressBarProvider>
          </DeviceContextProvider>
        </AuthContextProvider>
      </body>
    </html>
  );
}
