import { NextResponse } from "next/server";
import getBase64ImageUrl from "@/app/_utils/generatePlaceHolder";

export async function GET(req) {
  // Fetch This information from API
  const configurationData = {
    signInBg: {
      image: {
        url: "/images/Auth/sign-in-bg.jpg",
        alt: "sign-in",
      },
    },
    signUpBg: {
      image: {
        url: "/images/Auth/sign-up-bg.jpg",
        alt: "sign-in",
      },
    },
    stickyInfo: {
      image: {
        url: "https://www.keralatourism.org/images/covid19/healthadvisoryfornipah.jpg",
        alt: "nipha-advaisory",
      },
      link: {
        type: "external",
        parent: "https://www.keralatourism.org/nipah",
        text: "Nipha Advaisory",
        title: "Nipha Advaisory",
        slug: "",
      },
    },
  };

  let reducedResults = configurationData;

  // Generating Base64 Placeholder for the data
  const configKeys = Object.keys(reducedResults);
  for await (const key of configKeys) {
    const { url } = reducedResults[key].image;
    await getBase64ImageUrl(url).then((result) => {
      reducedResults[key] = {
        ...reducedResults[key],
        image: {
          ...reducedResults[key].image,
          base64: result,
        },
      };
    });
  }

  return NextResponse.json(reducedResults);
}
