import { NextResponse } from "next/server";
import getBase64ImageUrl from "@/app/_utils/generatePlaceHolder";

export async function GET(req) {
  const advertisementData = {
    title: "Ten off-beat wedding location in Kerala",
    description:
      "Every day is a lazy, laid-back day here if you want it to be, that is. You can begin your day with a hot cuppa in hand, walk along",
    link: {
      type: "internal",
      text: "More",
      title: "More",
      parent: "/video-gallery",
      slug: "/offbeat",
    },
    image: {
      url: "/images/advertisement.jpg",
      alt: "advertisement",
    },
  };

  const reducedResults = advertisementData;

  reducedResults.image = {
    ...reducedResults.image,
    base64: await getBase64ImageUrl(reducedResults.image.url).then(
      (res) => res
    ),
  };

  return NextResponse.json(reducedResults);
}
