// Conversion for pixel unit to rem unit
export const pxToRem = (number, baseNumber = 18) =>
  `${(number / baseNumber).toFixed(2)}rem`;

// Splitting array in to chunks based on the chunksize
// Provided
export const splitArrayIntoChunks = (arr, chunkSize) => {
  const chunks = [];
  let i = 0;

  while (i < arr.length) {
    chunks.push(arr.slice(i, i + chunkSize));
    i += chunkSize;
  }
  return chunks;
};

// Month Array
export const months = [
  "JAN",
  "FEB",
  "MAR",
  "APR",
  "MAY",
  "JUN",
  "JUL",
  "AUG",
  "SEPT",
  "OCT",
  "NOV",
  "DEC",
];

// Utitlity function for checkin the object is empty or not
export const isObjectEmpty = (obj) =>
  Object.keys(obj).length === 0 && obj.constructor === Object;

// Shimmer SVG
export const shimmer = (w, h) => `
  <svg width="${w}" height="${h}" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <defs>
      <linearGradient id="g">
        <stop stop-color="#FFD057" offset="20%" />
        <stop stop-color="#CC9505" offset="50%" />
        <stop stop-color="#FFD057" offset="70%" />
      </linearGradient>
    </defs>
    <rect width="${w}" height="${h}" fill="#FFD057" />
    <rect id="r" width="${w}" height="${h}" fill="url(#g)" />
    <animate xlink:href="#r" attributeName="x" from="-${w}" to="${w}" dur="1s" repeatCount="indefinite"  />
  </svg>`;

// toBase64 func
export const toBase64 = (str) =>
  typeof window === "undefined"
    ? Buffer.from(str).toString("base64")
    : window.btoa(str);

// Creating Application Page Meta data
/** @type {import("next").Metadata} */
export const getMetaData = ({ title, description, keywords, og }) => ({
  title,
  description,
  keywords,
  openGraph: {
    title: og.title,
    description: og.description,
    url: og.url,
    images: [
      {
        url: og.image,
        width: 800,
        height: 600,
      },
    ],
  },
});
