import { getPlaiceholder } from "plaiceholder";
import fs from "fs/promises";
import path from "path";

const cache = new Map();

export default async function getBase64ImageUrl(src) {
  let base64 = cache.get(src);
  if (base64) {
    return base64;
  }

  // Keep this one after changed all the images url to remote
  // const buffer = await fetch(src).then(async (res) =>
  //   Buffer.from(await res.arrayBuffer())
  // );

  // Remove The Below Lines from here to 29 after all the images loading 
  // from an external url
  const fileType = src.includes("http") ? "remote" : "static";
  let buffer;
  
  if (fileType === "remote") {
    src=src.replace(new RegExp(`http://${process.env.HOST_IP}|http://${process.env.LOCAL_IP}`, 'g'), process.env.LOCAL_URL)
    .replace(new RegExp(`http://${process.env.MASK_IP}`, 'g'), process.env.PUBLIC_URL);

    buffer = await fetch(src).then(async (res) =>
      Buffer.from(await res.arrayBuffer())
    );
  } else {   
    buffer = await fs.readFile(path.join("./public", src));
  }

  let base64PlaiceHolder = await getPlaiceholder(buffer, { size : 10});
  cache.set(src, base64PlaiceHolder.base64);
  return base64PlaiceHolder.base64;
}
