import { extendTheme } from "@chakra-ui/react";

import fonts from "./fonts";
import global from "./global";
import colors from "./colors";
import textStyles from "./textStyle";

// Importing chakra custom components
import Link from "./components/link";
import { radioTheme } from "./components/radio";
import { cardTheme } from "./components/card";

export const theme = extendTheme({
  config: {
    cssVarPrefix: "kerala-tourism",
  },
  styles: {
    global,
  },
  fonts,
  textStyles,
  shadows: {
    custom: "0px 0px 15px var(--kerala-tourism-colors-antiFlashWhite)",
  },
  colors,
  sizes: {
    container: {
      "2xl": "1536px",
    },
  },
  components: {
    Link,
    Radio: radioTheme,
    Card: cardTheme,
  },
});
