import { radioAnatomy } from "@chakra-ui/anatomy";
import { createMultiStyleConfigHelpers } from "@chakra-ui/react";

const { definePartsStyle, defineMultiStyleConfig } =
  createMultiStyleConfigHelpers(radioAnatomy.keys);

const baseStyle = definePartsStyle({
  control: {
    borderColor: "orangePeel.900",
    _checked: {
      _before: {
        background: "orangePeel.900",
        width: "75%",
        height: "75%",
      },
      _hover: {
        background: "white",
        borderColor: "orangePeel.900",
      },
      background: "white",
      borderColor: "orangePeel.900",
    },
    _focus: {
      boxShadow: "none",
    },
  },
  label: {
    color: "#333536"
  }
});

export const radioTheme = defineMultiStyleConfig({ baseStyle });
