import { defineStyleConfig } from "@chakra-ui/react";

const Link = defineStyleConfig({
  baseStyle: {
    display: "inline-flex",
    alignItems: "center",
    gap: 2,
    //textTransform: "capitalize",
    textDecoration: "none",
    transition: "all 0.4s ease-in-out",
    _hover: {
      "svg path": {
        fill: "orangePeel.900",
      },
      textDecoration: "none",
      color: "orangePeel.900",
    }
  },
  variants: {
    default: {
      fontSize: "18px",
    },
    pill: {
      border: "1px",
      borderRadius: "full",
      height: "32px",
      fontSize: "14px",
      paddingRight: "12px",
      paddingLeft: "12px",
      textAlign: "center",
      _hover: {
        borderColor: "orangePeel.900",
      },
    },
    unpill: {
      border: "1px",
      borderColor: "transparent",
      height: "32px",
      fontSize: "14px",
      paddingRight: "12px",
      paddingLeft: "0px",
      textAlign: "center",
    }
  },
  defaultProps: {
    variant: "default",
  },
});

export default Link;
