"use client";

import { CacheProvider } from "@chakra-ui/next-js";
import { ChakraProvider } from "@chakra-ui/react";

import { playFair, ibmPlex } from "@/app/font";

import { theme } from "@/app/_theme";

export function ThemeProvider({ children }) {
  return (
    <>
      <style jsx global>
        {`:root {
          --font-play-fair: ${playFair.style.fontFamily};
          --font-ibm-plex: ${ibmPlex.style.fontFamily};
        }`}
      </style>
      <CacheProvider>
        <ChakraProvider theme={theme}>{children}</ChakraProvider>
      </CacheProvider>
    </>
  );
}
