import "server-only";

import isMobile from "ismobilejs";
import { headers } from "next/headers";

import {
  COMPONENT_TYPES,
  APP_HEADER,
  APP_PORTFOLIO,
  APP_FOOTER,
  BANNER_CATEGORIES,
  SECTION_HEADING,
} from "@/app/_constants/componentConstant";

const {
  BANNER,
  SLIDER,
  ESSENTIAL,
  EVENTCALENDAR,
  HIGHLIGHT_STORY,
  TOP_HEADING,
  LIST,
  FILTER,
  GRID_LIST,
  GRID,
  ARTICLE,
  GALLERY_GRID,
  TRAVEL_INFO,
  EBROCHURE,
  SUBSCRIPTION,
  VIDEO_PLAYER,
  HIGHLIGHT_CARD,
  PROFILE,
  GALLERY,
} = COMPONENT_TYPES;

const { SUB_BANNER } = BANNER_CATEGORIES;

// Importing application Header
import { Header, Portfolio, Footer } from "@/app/_includes";

// Importing common components
import SectionHeading from "@/app/_components/SectionHeading";

// Importing application page Components
import {
  Article,
  Banner,
  Ebrochure,
  Essential,
  Eventcalendar,
  CommonFilter,
  Gallery,
  GalleryGrid,
  Grid,
  HighlightBgStory,
  HighlightCard,
  List,
  Profile,
  Slider,
  Subscription,
  ScrollHeading,
  TravelInfo,
  VideoPlayer,
} from "@/app/_components/_page";

// Mapping the components with specified key
const _rootComponents = {
  [APP_HEADER]: Header,
  [APP_PORTFOLIO]: Portfolio,
  [APP_FOOTER]: Footer,
  [SECTION_HEADING]: SectionHeading,
  [BANNER]: Banner,
  [SLIDER]: Slider,
  [ESSENTIAL]: Essential,
  [EVENTCALENDAR]: Eventcalendar,
  
  [HIGHLIGHT_STORY]: HighlightBgStory,
  [HIGHLIGHT_CARD]: HighlightCard,
  [TOP_HEADING]: ScrollHeading,
  [LIST]: List,
  [FILTER]: CommonFilter,
  [GRID]: Grid,
  [ARTICLE]: Article,
  [GALLERY_GRID]: GalleryGrid,
  [TRAVEL_INFO]: TravelInfo,
  [EBROCHURE]: Ebrochure,
  [VIDEO_PLAYER]: VideoPlayer,
  [SUBSCRIPTION]: Subscription,
  [PROFILE]: Profile,
  [GALLERY]: Gallery,
};

/**
 * Main Function for bootstrapping or generating the
 * Html page in the server based on the provided
 * blocks using dynamic rendering sttrategy in Next JS.
 *
 * https://nextjs.org/docs/app/building-your-application/rendering/server-components
 *
 * @param {*} blocks
 * @param {*} _hMap
 * @returns array
 */
export async function registerComponents(blocks, _hMap = new Map()) {
  //console.log("registerComponents",blocks);
  const _pageComponents = [];
  const mediaQueryFallback = isMobile(headers().get("user-agent")).any;

  let _i = 0;

  _hMap.set("has_sub_banner", false);

  if (!_hMap.has("has_header")) {
    _hMap.set("has_header", true);
    pushComponents(_pageComponents, _rootComponents[APP_HEADER], {
      has_sub_banner: _hMap.get("has_sub_banner"),
      mediaQueryFallback,
    });
  }

  if (!_hMap.has("has_add_additional_components")) {
    _hMap.set("has_add_additional_components", true);
    [APP_PORTFOLIO, APP_FOOTER].forEach((item) => {
      blocks.push({ block: { type: item } });
    });
  }

  while (_i < blocks.length) {
    const { type } = blocks[_i]["block"];
    let props = { mediaQueryFallback };

    if (type === BANNER) {
      const { category } = blocks[_i]["block"];
      if (category === SUB_BANNER) {
        const [Header, props] = _pageComponents[0];
        _hMap.set("has_sub_banner", true);
        _pageComponents[0] = [
          Header,
          { ...props, has_sub_banner: _hMap.get("has_sub_banner") },
        ];
      }
    } else if (type === TOP_HEADING) {
      props = {
        has_sub_banner: _hMap.get("has_sub_banner"),
      };
    } else if (type === GRID_LIST) {
      pushComponents(_pageComponents, _rootComponents[SECTION_HEADING], {
        description: blocks[_i]?.description,
      });
      if (
        blocks[_i].hasOwnProperty("items") &&
        blocks[_i]["items"] instanceof Array
      ) {
        await registerComponents(blocks[_i]["items"], _hMap).then((_c) =>
          _c.every((_i) => _pageComponents.push(_i))
        );
      }
    } else if (type === GRID) {
      if (_hMap.has("_seq")) {
        let _seq = _hMap.get("_seq");
        _hMap.set("_seq", ++_seq);
      } else _hMap.set("_seq", 1);
      props = {
        sequence: _hMap.get("_seq"),
      };
    }

    if (type in _rootComponents) {
      pushComponents(_pageComponents, _rootComponents[type], {
        ...blocks[_i],
        ...props,
      });
    }
    _i++;
  }

  return _pageComponents;
}

function pushComponents(componentArray, component, props) {
  componentArray.push([component, { ...props }]);
}
