import "server-only";

export function loadArtformJSON(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1) return "artform.json";
  else if (requestedParams.has("list") && params.at(-1) === "list")
    return "artform_list.json";
  else if (requestedParams.has("details") && params.at(-1) === "details")
    return "artform_details.json";
  else return undefined;
}

export function loadAwardJSON(requestedParams) {
  if (requestedParams.size === 1) return "awards.json";
  else return undefined;
}

export function loadContactUsJSON(requestedParams) {
  if (requestedParams.size === 1) return "contact_us.json";
  else return undefined;
}

export function loadDestinationJSON(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1) return "destination.json";
  else if (requestedParams.has("categories") && params.at(-1) === "categories")
    return "destination_categories.json";
  else if (requestedParams.has("list") && params.at(-1) === "list")
    return "destination_category_list.json";
  else if (requestedParams.has("details") && params.at(-1) === "details")
    return "destination_details.json";
  else return undefined;
}

export function loadDistrictJson(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1) return "district.json";
  else if (requestedParams.has("details") && params.at(-1) === "details")
    return "district_details.json";
  else return undefined;
}

export function loadEbrouchureJSON(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1) return "e_brouchures.json";
  else if (requestedParams.has("details") && params.at(-1) === "details")
    return "e_brouchure_details.json";
  else return undefined;
}

export function loadEventJSON(requestedParams) {
  return undefined;
}

export function loadImageGalleryJSON(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1 && params.at(-1) === "photo-gallery")
    return "photo_gallery.json";
  else if (
    requestedParams.size === 1 &&
    params.at(-1) === "highresolutionimages"
  )
    return "high_resolution_images.json";
  else return undefined;
}

export function loadHowToJSON(requestedParams) {
  if (requestedParams.size === 1) return "how_to.json";
  else return undefined;
}

export function loadKeralaAtAGlanceJSON(requestedParams) {
  if (requestedParams.size === 1) return "kerala_at_a_glance.json";
  else return undefined;
}

export function loadKeralaFoodJSON(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1) return "kerala_food.json";
  else if (requestedParams.has("list") && params.at(-1) === "list")
    return "kerala_food_list.json";
  else if (requestedParams.has("details") && params.at(-1) === "details")
    return "kerala_food_details.json";
  else return undefined;
}

export function loadKeralaStoryJSON(requestedParams) {
  const params = [...requestedParams];

  if (requestedParams.size === 1) return "kerala_story_list.json";
  else if (requestedParams.has("details") && params.at(-1) === "details")
    return "kerala_story_details.json";
  else return undefined;
}

export function loadMediaRoomJSON(requestedParams) {
  if (requestedParams.size === 1) return "media_room.json";
  else return undefined;
}

export function loadMicroSitesJSON(requestedParams) {
  if (requestedParams.size === 1) return "microsite.json";
  else return undefined;
}

export function loadMunnarJSON(requestedParams) {
  return undefined;
}

export function loadNewsLetterJSON(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1) return "newsletter.json";
  else if (requestedParams.has("details") && params.at(-1) === "details")
    return "newsletter_details.json";
  else return undefined;
}

export function loadOtherWebsiteJSON(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1) return "other_websites.json";
  else if (requestedParams.has("details") && params.at(-1) === "details")
    return "other_website_details.json";
  else return undefined;
}

export function loadPlanYourItineraryJSON(requestedParams) {
  if (requestedParams.size === 1) return "plan_your_itinerary.json";
  else return undefined;
}

export function loadProfileJSON(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1) return "my_profile.json";
  else if (
    requestedParams.has("upload-stories") &&
    params.at(-1) === "upload-stories"
  )
    return "my_profile_stories_upload.json";
  else return undefined;
}

export function loadSouvenirShopsJSON(requestedParams) {
  if (requestedParams.size === 1) return "souvenirs_shops.json";
  else return undefined;
}

export function loadSouvenirsJSON(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1) return "souvenirs.json";
  else if (requestedParams.has("details") && params.at(-1) === "details")
    return "souvenirs_details.json";
  else return undefined;
}

export function loadTourGuidesJSON(requestedParams) {
  if (requestedParams.size === 1) return "tour_guides.json";
  else return undefined;
}

export function loadTourPackagesJSON(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1) return "tour_packages.json";
  else if (requestedParams.has("details") && params.at(-1) === "details")
    return "tour_packages_details.json";
  else return undefined;
}

export function loadTourismInfoCenterJSON(requestedParams) {
  if (requestedParams.size === 1) return "tourism-info-center.json";
  else return undefined;
}

export function loadTourismVisionJSON(requestedParams) {
  if (requestedParams.size === 1) return "tourism_vision.json";
  else return undefined;
}

export function loadTouristVisaOnArrivalJSON(requestedParams) {
  if (requestedParams.size === 1) return "tourist_visa_on_arrival.json";
  else return undefined;
}

export function loadTravelDeskJSON(requestedParams) {
  if (requestedParams.size === 1) return "travel_desk.json";
  else return undefined;
}

export function loadTravelTripsJSON(requestedParams) {
  if (requestedParams.size === 1) return "travel_tips.json";
  else return undefined;
}

export function loadVarkalaJSON(requestedParams) {
  return undefined;
}

export function loadVideoGalleryJSON(requestedParams) {
  if (requestedParams.size === 1) return "video_gallery.json";
  else return undefined;
}

export function loadWhereToStayJSON(requestedParams) {
  const params = [...requestedParams];
  if (requestedParams.size === 1) return "where_to_stay.json";
  else if (requestedParams.has("details") && params.at(-1) === "details")
    return "where_to_stay_details.json";
  else return undefined;
}
