import "server-only";

import { headers } from "next/headers";
import path from "path";
import { promises as fs } from "fs";
import { notFound } from "next/navigation";

// Function for load static json Data to the application
export async function loadStaticData(fileName) {
  const staticDataDirectory = path.join(process.cwd(), "src/app/_data");
  const data = await fs
    .readFile(`${staticDataDirectory}/${fileName}`, "utf8")
    .then((data) => JSON.parse(data));

  return data;
}










// Function for detecting devices
export async function detectDevice() {
  const DeviceDetector = eval('require("node-device-detector")');
  const DeviceHelper = eval('require("node-device-detector/helper")');

  const device = new DeviceDetector({
    clientIndexes: true,
    deviceIndexes: true,
    deviceAliasCode: true,
  });

  const result = device.detect(headers().get("user-agent"));
  return {
    isDesktop: DeviceHelper.isDesktop(result),
    isTablet: DeviceHelper.isTablet(result),
    isMobile: DeviceHelper.isMobile(result),
  };
}

// End Point Base URL
export const BASE_URL = process.env.KT_API_BRIDGE_URL;
export const APP_BASE_URL = process.env.APP_BASE_URL;

const HOME = "/home/details";
const ARTICLE = "/article/details?slug=";
// Function for load dynamic json Data to the application
// export const getArticleInfo = async (slug) =>
// await fetch(`${BASE_URL}${ARTICLE}${slug}`, { headers: authHeaders, cache: "no-store", method : "GET" }).then((res) => res.json());

export const getArticleInfo = async (slug) => {
  const response = await fetch(`${BASE_URL}${ARTICLE}${slug}`, {
    headers: authHeaders,
    cache: "no-store",
    method: "GET"
  });
  
  if (response.status === 400 || response.status === 401 || response.status === 404 || response.status === 422 || response.status === 500 ) {
    return notFound();
  }

  return response.json();
};

const MYSTORY = "/mystory/detail?story_id=";
// Function for load dynamic json Data to the application
// export const getArticleInfo = async (slug) =>
// await fetch(`${BASE_URL}${ARTICLE}${slug}`, { headers: authHeaders, cache: "no-store", method : "GET" }).then((res) => res.json());

export const getMystoryInfo = async (slug) => {
  const response = await fetch(`${BASE_URL}${MYSTORY}${slug}`, {
    headers: authHeaders,
    cache: "no-store",
    method: "GET"
  });
  
  if (response.status === 400 || response.status === 401 || response.status === 404 || response.status === 422 || response.status === 500 ) {
    return notFound();
  }

  return response.json();
};


//Function to load home page data

export const getHomeInfo = async () =>
  await fetch(`${BASE_URL}${HOME}`, { headers: authHeaders, cache: "no-store", method : "GET" }).then((res) => res.json());


// API URI's
const MAIN_MENU = "/home/megamenu_main";
export const MEGA_MENU_SUB = (slug) => `/home/megamenu_sub?slug=megamenu/${slug}`;

// Authorization Header for calling external api
export const authHeaders = {
  Authorization: `Bearer ${process.env.AUTHORIZATION_KEY}`,
};

export const getMegaMenu = async () =>
  fetch(`${BASE_URL}${MAIN_MENU}`, { headers: authHeaders }).then((res) =>
    res.json()
  );

export const getAppConfiguration = async () =>
  fetch(`${APP_BASE_URL}/configuration`).then((res) =>
    res.json()
  );

export const getSubscriptionInfo = async (slug) => {    
    const response = await fetch(`${BASE_URL}newsletter/subscribe`, {   
      headers: authHeaders,
      credentials: 'include',
      cache: "no-store",
      method: "POST",
      body: JSON.stringify(slug)
    });
  
    if (response.status === 404) {
      return notFound();
    }
  
    return response.json();
  };


  
