import NextAuth from "next-auth"
import CredentialsProvider from "next-auth/providers/credentials";
import { authConfig } from "@/app/_libs/auth.config";
import Swal from 'sweetalert2';

const login = async (credentials) => {
    try {
        const slg = "auth/login";        
        const authHeaders = {
            Authorization: `Bearer ${process.env.NEXT_PUBLIC_AUTHORIZATION_KEY}`,
            'Content-Type': `application/json`
          };
         
        const response = await fetch(`${process.env.NEXT_PUBLIC_KT_BRIDGE_URL}${slg}`, {   
            headers: authHeaders,
            credentials: 'include',
            cache: "no-store",
            method: "POST",
            body: JSON.stringify(credentials)
          });
         
          if (response.status === 404 || response.status === 201) {
            return response;
          }
          else{
            return response;
          }
      } catch (err) {
        console.log(err);
        throw new Error("Failed to login!");
      }
};

export const { handlers:{GET,POST}, auth, signIn, signOut } = NextAuth(
 { ...authConfig,
    providers: [ 
    CredentialsProvider({
        async authorize(credentials) { 
            try {
            const response = await login(credentials);           
            const user=await response.json();
            return user;
           
            } catch (err) {
            return null;
            }
            },
        }), 
    ],
    callbacks: {
       
        authorized({ auth, request }) {
            console.log("auth");
            //console.log(auth);
        }
       // ...authConfig.callbacks,
       // async signIn({ user, account}) {           
            /* if (account.provider === "credentials") {
                data=await user.json();
                try {
                    if(user.status===200){
                        data=await user.json();
                        const newUser = new User({
                            id: data.user_id,
                            username: data.user_name,
                            email: data.user_email,
                            mobile: data.user_phone,
                        });
                        await newUser.save();
                        return true;
                    }
                } catch (err) {
                    Swal.fire({
                        icon: 'error',
                        title: data.message,
                        didOpen: () => {
                          const swalContainer = Swal.getContainer();
                          swalContainer.style.zIndex = 9999;
                        }
                      });       
                    console.log(data.message);
                    return false;
              }
            }   */              
         // return true;
        //},
        
      },
}
);