"use client";

import { Box } from "@chakra-ui/react";
import { AppImage, AppLink } from "@/app/_components";
import { useConfigurationContext } from "@/app/_context";

export default function StickyAd() {
  const { data } = useConfigurationContext();

  if (data?.stickyInfo) {
    const {
      image: { url, alt, base64 },
      link: { text, ...restLinkProps },
    } = data.stickyInfo;
    return (
      <AppLink {...restLinkProps} display="block">
        <Box
          pos="fixed"
          left={7}
          bottom={7}
          h="50px"
          borderRadius="md"
          sx={{ img: { borderRadius: "md" } }}
          width="300px"
          zIndex="999"
        >
          <AppImage
            src={url}
            alt={alt}
            blurDataURL={base64}
            fill
            style={{ width: "100%" }}
          />
        </Box>
      </AppLink>
    );
  }

  return null;
}
