"use client";

import { Box } from "@chakra-ui/react";

import { useEffect } from "react";
import scrollToTop from "@/app/_utils/scrollToTop";

const ScrollToTop = () => {
  useEffect(() => {
    scrollToTop();
  });

  return (
    <Box
      className="progress-wrap"
      bg="white"
      shadow="md"
      display="block"
      h={12}
      w={12}
      borderRadius="full"
      zIndex={30}
      visibility="hidden"
      opacity={0}
      transform="translateY(5px)"
      cursor="pointer"
      pos="fixed"
      bottom={7}
      right={7}
      transition="400ms linear"
      _after={{
        content: "url(/icons/up-arrow.svg)",
        display: "block",
        zIndex: "10px",
        pos: "absolute",
        textAlign: "center",
        lineHeight: 10,
        color: "gray.100",
        h: 8,
        w: 8,
        cursor: "pointer",
        left: 0,
        right: 0,
        top: 2,
        mx: "auto",
      }}
      sx={{
        "svg.progress-circle path": {
          stroke: "#ffc619",
          strokeWidth: "6px",
          boxSizing: "border-box",
        },
      }}
    >
      <svg
        className="progress-circle svg-content"
        width="100%"
        height="100%"
        viewBox="-1 -1 102 102"
      >
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" fill="none" />
      </svg>
    </Box>
  );
};

export default ScrollToTop;
