"use client";

import { Box, Flex } from "@chakra-ui/react";
import { KtHeading } from "@/app/_components";

export default function NotFoundInfo() {
  return (
    <Box
      h="100vh"
      pos="relative"
      _before={{
        content: "''",
        pos: "absolute",
        top: 0,
        left: 0,
        bottom: 0,
        zIndex: 1,
        w: "full",
        h: "full",
        bgGradient: "linear(blackAlpha.600 0%, whiteAlpha.50 100%)",
      }}
    >
      <Box
        as="video"
        src="/videos/backWater.mp4"
        objectFit="cover"
        h="full"
        w="full"
        loop
        autoPlay
        muted
        playsInline
      />
      <Flex
        direction="column"
        pos="absolute"
        top={0}
        h="full"
        w="full"
        justify="center"
        align="center"
        gap={6}
        textAlign="center"
        p={8}
      >
        <KtHeading as="h2" color="orangePeel.900">
          404
        </KtHeading>
        <KtHeading as="h4" color="orangePeel.900">
          The Requested Resource Was Not found on this Server
        </KtHeading>
      </Flex>
    </Box>
  );
}
