import getBase64ImageUrl from "@/app/_utils/generatePlaceHolder";
import AppHeader from "./components/AppHeader";
import { MenuContextProvider } from "@/app/_context";

import { getMegaMenu } from "@/app/_libs";

async function Header({ has_sub_banner, mediaQueryFallback }) {
  const data = await getMegaMenu();
 // const data ='';
  //const data ='';
  const updatedData = JSON.parse(
    JSON.stringify(data)
    .replace(new RegExp(`http://${process.env.HOST_IP}|http://${process.env.LOCAL_IP}`, 'g'), process.env.LOCAL_URL)
    .replace(new RegExp(`http://${process.env.MASK_IP}`, 'g'), process.env.PUBLIC_URL)
);

  let reducedResults = updatedData;

  const headerKeys = new Map();

  Object.keys(reducedResults).forEach((_k) => {
    if (_k !== "plan_your_trip") headerKeys.set(_k, updatedData[_k]);
  });

  const mapSize = headerKeys.size;
  const headerIterator = headerKeys.entries();
  let currentIterator = 1;

  while (currentIterator <= mapSize) {
    const [menuKey, values] = headerIterator.next().value;
    const { menu } = values;

    await Promise.all(
      menu.map(async (item) => {
        if (item.hasOwnProperty("learn_more")) {
          item.learn_more = {
            ...item.learn_more,
            image: {
              ...item.learn_more.image,
              base64: await getBase64ImageUrl(item.learn_more.image.url),
            },
          };
        }
        if (item?.subMenu?.length > 0) {
          await Promise.all(
            item.subMenu.map(async (item) => ({
              ...item,
              image: {
                ...item.image,
                base64: await getBase64ImageUrl(item.image.url),
              },
            }))
          ).then((res) => {
            item.subMenu = res
          })
        }
        return item;
      }),
    ).then((result) => {
      reducedResults[menuKey].menu = result;
    });

    currentIterator++;
  }

  return (
    <MenuContextProvider data={reducedResults}>
      <AppHeader hasSubBanner={has_sub_banner} fallback={mediaQueryFallback} />
    </MenuContextProvider>
  );
}

export default Header;
