import { motion } from "framer-motion";
import {
  Box,
  Grid,
  Alert,
  AlertIcon,
  AlertTitle,
  AlertDescription,
  Button,
} from "@chakra-ui/react";
import { BeatLoader } from "react-spinners";

export function GridListWrapper({ children }) {
  return (
    <Grid
      as={motion.div}
      templateColumns={{
        md: "repeat(3, 1fr)",
        xl: "repeat(4, 1fr)",
      }}
      gap={{
        md: 4,
        lg: 8,
      }}
    >
      {children}
    </Grid>
  );
}

export function ApiLoader({ pt = 40 }) {
  return (
    <Box pt={pt} display="flex" justifyContent="center" alignItems="center">
      <BeatLoader
        loading={true}
        size={20}
        color="#FF9D00"
        cssOverride={{
          display: "block",
          margin: "0 auto",
        }}
      />
    </Box>
  );
}

export function ApiError({ message, onBack }) {
  return (
    <Alert status="error">
      <AlertIcon />
      <AlertTitle>API ERROR!.</AlertTitle>
      <AlertDescription>{message}</AlertDescription>
      <Button ml={8} onClick={() => onBack()}>
        Back
      </Button>
    </Alert>
  );
}
