import { useState, useEffect, useRef } from "react";
import { useQuery } from "@tanstack/react-query";

// Setting TabIndex And Selected Link
export const useTabIndex = () => {
  const [link, setLink] = useState({});
  const [tabIndex, setTabIndex] = useState(0);

  useEffect(() => {
    setLink({});
  }, [tabIndex]);

  return [link, tabIndex, setLink, setTabIndex];
};

// Setting The Tab Style Based on the Ref and
// Scroll Width
export const useTabStyle = () => {
  const tabListRef = useRef(null);
  const [tablistStyleProps, setTabListStyleProps] = useState({
    display: "grid",
    gridAutoFlow: "column",
    overflowX: "auto",
    scrollSnapType: "x mandatory",
    scrollPadding: "1rem",
  });

  useEffect(() => {
    if (tabListRef.current.scrollWidth > tabListRef.current.clientWidth) {
      setTabListStyleProps((prev) => ({
        ...prev,
        paddingBottom: "6px",
        placeContent: "flex-start",
      }));
    } else {
      setTabListStyleProps((prev) => ({
        ...prev,
        paddingBottom: 0,
        placeContent: "center",
      }));
    }
  }, [tabListRef]);

  return [tabListRef, tablistStyleProps];
};

export const useSubMenuData = (enabled = false, slug) => {
  const { data: subMenu, isLoading, error, isError } = useQuery({
    queryKey: ["submenu", slug],
    retry: false,
    queryFn: () => fetch(`/api/submenu/${slug}`).then((res) => res.json()),
    enabled
  });

  return {
    subMenu,
    isLoading,
    error,
    isError
  };
}
