"use client";

import dynamic from "next/dynamic";
import Link from "next/link";

import { useRef, useMemo, useCallback, useState } from "react";


import { useSize } from "@chakra-ui/react-use-size";
import { Box, Flex, Image, useMediaQuery } from "@chakra-ui/react";

import { KtContainer, AppModal } from "@/app/_components";
import { useMenuContext, useDispatchContext } from "@/app/_context";

import Nav from "./_components/Nav";
import HeaderIcon from "./_components/HeaderIcon";
import AppDrawer from "./_components/AppDrawer";
//import Favourite from "./_components/Favourite";
//import Language from "./_components/Language";

const MegaMenuModal = dynamic(() => import("./_components/MegaMenuModal"));
const Search = dynamic(() => import("./_components/Search"));

const headerBaseStyle = {
  width: "full",
  py: {
    base: 4,
    md: 6,
  },
};

const relativeHeaderStyle = {
  pos: "relative",
};

const headerAbsoluteStyle = {
  pos: "absolute",
};

const fixedHeaderStyle = {
  pos: "fixed",
  shadow: "md",
  bg: "white",
  zIndex: 9999,
};

/**
 * Main Application Header
 * For the app
 */
function AppHeader({ hasSubBanner }) {
  const dispatch = useDispatchContext();
  const { isOpen, isOpenSearch, activeKey } = useMenuContext();
  const [isHovered, setIsHovered] = useState(false);
  const headerRef = useRef(null);
  const size = useSize(headerRef);

  const [isMobile] = useMediaQuery(["(max-width: 768px)"]);

  const style = useMemo(
    () => ({
      ...headerBaseStyle,
      ...(hasSubBanner && !isOpen ? relativeHeaderStyle : {}),
      ...(!hasSubBanner && !isOpen ? headerAbsoluteStyle : {}),
      ...(!hasSubBanner ? { zIndex: 9 } : {}),
      ...(isOpen ? fixedHeaderStyle : {}),
    }),
    [hasSubBanner, isOpen]
  );

  const currentColor = useMemo(() => {
    
    if (!hasSubBanner && !isOpen && !isHovered) return "#fff";
    else return "#000";
  }, [hasSubBanner, isOpen, isHovered]);

  const handleOpenSearch = useCallback(() => {
    if (isOpen) {
      dispatch({ type: "HANDLE_MEGA_MENU", value: false });
      dispatch({ type: "SET_ACTIVE_KEY", value: "" });

      if (activeKey === "where-to-go")
        dispatch({ type: "SET_CHILDREN", value: false });
      
    }
    

    setTimeout(() => {
      dispatch({ type: "HANDLE_SEARCH_MODAL", value: true });
      setIsHovered(false);
    }, 300);
  }, [dispatch, isOpen]);
  

  return (
    <Box as="header" ref={headerRef} {...style} transition="all linear 0.2s"
    
    bgGradient="linear(to-t, transparent 1%, blackAlpha.100 0%, whiteAlpha.50 100%)"
    _hover={{
      bgGradient: "linear-gradient(to top, rgb(255 255 255 / 64%) 0%, rgb(46 46 46 / 0%) 100%)", // Example gradient on hover
    }}
      onMouseEnter={() => setIsHovered(true)}
      onMouseLeave={() => setIsHovered(false)}
    >
      <KtContainer>
        {/* App Navigation */}
        <Box as="nav" pos="relative" >
          <Flex
            align="center"
            justify="space-between"
            sx={{
              "@media screen and (max-width:768px)": {
                ".app__main-navigation": {
                  display: "none",
                },
              },
            }}
          >
            <Link href="/" title="Home">
              <Image
                src="/images/logo/logo.png"
                width={["60px", "70px", "90px"]}
                alt="Kerala Tourism"
              />
            </Link>
            {!isMobile && (
              <Box className="app__main-navigation" >
                <Nav navColor={currentColor} />
              </Box>
            )}
            <Flex
              gap={{
                base: 1
              }}
              justify="space-between"
              align="center"
              sx={{
                "svg path, svg circle, svg line": {
                  stroke: currentColor,
                  transition: "0.5s linear",
                },
              }}
            >
              {/* <Language /> */}
              <HeaderIcon type="search" onClick={() => handleOpenSearch()} />
                             
              {/*<Favourite />*/}
              <AppDrawer isMobile={isMobile} />
              
            </Flex>
            
          </Flex>
        </Box>

        {/* Megamenu Modal */}
        {!isMobile && <MegaMenuModal height={size?.height ?? 0} />}

        {/* Search Modal */}
        <AppModal
          size="6xl"
          isOpen={isOpenSearch}
          onClose={() =>
            dispatch({ type: "HANDLE_SEARCH_MODAL", value: false })
          }
          closeBtnProps={{
            bg: "orangePeel.900",
            rounded: "full",
            fontSize: "12px",
            color: "white",
            zIndex: 5,
          }}
        >
          <Search />
        </AppModal>
        
      </KtContainer>
    </Box>
  );
}

export default AppHeader;
