"use client"

import { useState } from "react";
import { AppSearchInput, KtContainer } from "@/app/_components";
import { getArticleData } from "@/app/_libs/loadApi";

import { ApiLoader } from "../../../_includes";

import StaticShareLink from "./StaticShareLink";
import SearchList from "./SearchList";

//import { staticSearchData } from "../../../_data";

export default function Search() {
  const [searchData, setSearchData] = useState(() => []);
  const [isLoading, setIsLoading] = useState(() => false);

  const handleSearchAction = async (value) => {
    setIsLoading(true);
    setTimeout(async () => {
      if (value) {
        const OL_URL = process.env.NEXT_PUBLIC_OLD_URL;
        window.open(`${OL_URL}`+"/2024/search/?q="+value, "_blank");
        /*const result = await getArticleData("pagesearch&search="+value);
        if(result){
          setSearchData(result);
        }
        else{
          const OL_URL = process.env.NEXT_PUBLIC_OLD_URL;
          window.open(`${OL_URL}`+"/search/?q="+value, "_blank");
        }       */
      }
      else setSearchData([]);
      setIsLoading(false);
    }, 1000);
  };

  return (
    <KtContainer
      mt={{
        base: 16,
        lg: 36,
      }}
      px={{
        base: 0,
        lg: 8,
      }}
    >
      <AppSearchInput
        btnTitle="Search"
        serachInputAction={handleSearchAction}
      />
     {!isLoading && searchData.length <= 0}

      {isLoading && <ApiLoader />}

      {searchData.length > 0 && !isLoading && <SearchList items={searchData} />}
    </KtContainer>
  );
}
