import { useState, useEffect } from "react";
import Link from "next/link";
import { motion } from "framer-motion";
import { Grid, GridItem, Link as ChakraLink } from "@chakra-ui/react";
import { SvgArrow } from "@/app/_components/Svg";
import { getArticleData } from "@/app/_libs/loadApi";

export default function StaticShareLink() {

  const [defaultSearchList, setdefaultSearchList] = useState([]);

  useEffect(() => {
    const fetchDefaultData = async () => {
      try {
        const data = await getArticleData('footer-links');
       
        setdefaultSearchList(data);
      } catch (error) {
        console.error("Error fetching data:", error);
      }
    };

    fetchDefaultData();
  }, []);

  return (
    <Grid
      placeItems="center"
      templateColumns={{
        sm: "repeat(2, 1fr)",
        md: "repeat(3, 1fr)",
        xl: "repeat(4, 1fr)",
      }}
      gap={4}
    >
       
      {defaultSearchList.map(({ title, link, type }, key) => {
        let prnt;
        (type === "internal" || type === "link")
             ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL+link 
             : (type === "internal-other" )
             ? prnt=process.env.NEXT_PUBLIC_OLD_URL+link
             : prnt=link  
            
       
        let target;
         if (type === "external" || type === "internal-other" ) {
           target = 'target="_blank" rel="noopener noreferrer"';
         }
      // {Array(12)
      //   .fill(0)
      //   .map((item, idx) => (
        return (
          <GridItem key={key}>
            <Link href={`${prnt}`} passHref legacyBehavior>
              <ChakraLink
                py={4}
                px={6}
                title=""
                as={motion.a}
                gap={6}
                color="#6E6C6C"
                whileHover="hover"
                bg="transperant"
                display="inline-flex"
                justifyContent="center"
                alignItems="center"
                _hover={{
                  color: "orangePeel.900",
                  "svg path": {
                    fill: "orangePeel.900",
                  },
                }}
                {...(link.type !== "internal" && { ...{ target } })}
              >
                {title}
                <SvgArrow direction="ltr" color="black" />
              </ChakraLink>
            </Link>
          </GridItem>
        );
        })}
    </Grid>
  );
}
