import { Box, Grid, Flex, GridItem, Text } from "@chakra-ui/react";
import { KtHeading, AppImage, AppLink } from "@/app/_components";

import { appTextFontSize } from "@/app/_components/_styles";
import Link from 'next/link'

export default function SearchList({ items }) {
  
  return (
    <Grid
      templateColumns={{
        base: "repeat(1, 1fr)",
        lg: "repeat(2, 1fr)",
      }}
      //placeItems="center"
      gap={12}
      mb={12}
    >
      {items.map(
        ({
          _id,
          title,
          description,
          link: { text, ...restLinkProps },
          ...restProps
        }) => (
          <GridItem key={_id}>
            <Flex
              direction={{
                base: "column",
                md: "row",
              }}
              alignItems="center"
              gap={6}
            >
              {restProps?.image && (
                <Box aspectRatio={4 / 3} pos="relative" w="full" h="full">
                  <AppImage
                    src={restProps.image.url}
                    alt={restProps.image.alt}
                    fill
                    sizes="50vw"
                    style={{
                      borderRadius: "10px",
                    }}
                  />
                </Box>
              )}

              <Flex direction="column" gap={4}>
                <KtHeading as="h6">{title}</KtHeading>
                <Text fontSize={appTextFontSize}> {description} </Text>
                <Box display="inline-flex">
                  <AppLink
                    variant="pill"
                    color="black"
                    arrow
                    {...restLinkProps}
                  >
                    {text}
                  </AppLink>
                </Box>
              </Flex>
            </Flex>
          </GridItem>
        )
      )}
      <GridItem key='GoogleSearchResults'>
            <Flex
              direction={{
                base: "column",
                md: "row",
              }}
              alignItems="center"
              gap={6}
            >
              

              <Flex direction="column" gap={4}>
                <KtHeading as="h6">More Results</KtHeading>
                
                <Box display="inline-flex">
                  <Link
                    href={ "https://www.keralatourism.org/2024/search/?q=" + document.getElementById("searchKeyword").value}
                    target="_blank"
                  >
                    Click here to find more results
                  </Link>
                </Box>
              </Flex>
            </Flex>
          </GridItem>      
    </Grid>
  );
}
