import { UnorderedList, ListItem } from "@chakra-ui/react";
import { useDispatchContext, useMenuContext } from "@/app/_context";
import { appTextFontSize } from "@/app/_components/_styles";

import { mainNavItems } from "@/app/_includes/Header/components/_data";

import Link from 'next/link';

export default function Nav({ navColor }) {
  const dispatch = useDispatchContext();
  const { activeKey } = useMenuContext();

  const handleOpenMenu = async (key) => {
    dispatch({ type: "HANDLE_MEGA_MENU", value: true });
    dispatch({ type: "SET_ACTIVE_KEY", value: key });

    if (key === "where-to-go") dispatch({ type: "SET_CHILDREN", value: true });
    else dispatch({ type: "SET_CHILDREN", value: false });
  };

  return (
    <UnorderedList
      display="flex"
      justifyContent="center"
      alignItems="center"
      gap={{
        base: 0,
        md: 5,
      }}
      styleType="none"
      m={0}
    >
      {mainNavItems.map(({ title, key, link }) => (
        <ListItem
          color={activeKey === key ? "orangePeel.900" : navColor}
          pos="relative"
          cursor="pointer"
          transition="all 0.4s ease-in-out"
          key={key}
          p={{
            base: 2,
            md: 0,
          }}
          pb={1}
          onClick={() => handleOpenMenu(key)}
          fontSize={appTextFontSize}
        >
          {title}
          {/*<Link href={link}>{title}</Link>*/}
        </ListItem>
      ))}
    </UnorderedList>
  );
}
