import {
  Box,
  Modal,
  ModalContent,
  ModalBody,
  ModalCloseButton,
} from "@chakra-ui/react";
import { useMenuContext, useDispatchContext } from "@/app/_context";

import MegaMenu from "../MegaMenu";

export default function MegaMenuModal({ height }) {
  const { isOpen, activeKey } = useMenuContext();
  const dispatch = useDispatchContext();

  const onClose = () => {
    dispatch({ type: "HANDLE_MEGA_MENU", value: false });
    dispatch({ type: "SET_ACTIVE_KEY", value: "" });

    if (activeKey === "where-to-go")
      dispatch({ type: "SET_CHILDREN", value: false });
  };

  return (
    <Modal
      onClose={onClose}
      size="full"
      isOpen={isOpen}
      motionPreset="slideInBottom"
      scrollBehavior="inside"
    >
      <ModalContent bg="white" backdropFilter="blur(8px)">
        <ModalBody
          paddingInlineStart={{
            base: 0,
            "2xl": 6,
          }}
          paddingInlineEnd={{
            base: 0,
            "2xl": 6,
          }}
        >
          <Box pos="relative" top={`${height}px`}>
            <Box
              pos="absolute"
              top={0}
              right={{
                base: 0,
                "2xl": "30px",
              }}
            >
              <ModalCloseButton
                rounded="full"
                bg="orangePeel.900"
                fontSize="12px"
                zIndex={5}
                size="lg"
                color="white"
              />
            </Box>
            <MegaMenu />
          </Box>
        </ModalBody>
      </ModalContent>
    </Modal>
  );
}
