import { MotionConfig } from "framer-motion";
import { Box } from "@chakra-ui/react";
import { useMenuContext } from "@/app/_context";
import { KtContainer } from "@/app/_components";

import WhereToGoAndWhatToDo from "./_components/WhereToGoAndWhatToDo";
import PlanYourTrip from "./_components/PlanYourTrip";

export default function MegaMenu() {
  const { activeKey } = useMenuContext();
  const _megamenuWrapperStyle = {
    py:
      activeKey === "plan_your_trip"
        ? {
            md: 6,
            lg: 8,
          }
        : 0,
  };

  return (
    <MotionConfig transition={{ type: "easeIn", opacity: { duration: 0.5 } }}>
      <Box {..._megamenuWrapperStyle}>
        <KtContainer>
          {activeKey === "where-to-go" && (
            <WhereToGoAndWhatToDo key={activeKey} />
          )}
          {activeKey === "what_to_do" && (
            <WhereToGoAndWhatToDo key={activeKey} />
          )}
          {activeKey === "plan_your_trip" && <PlanYourTrip key={activeKey} />}
        </KtContainer>
      </Box>
    </MotionConfig>
  );
}
