import { motion } from "framer-motion";
import { Box, Image } from "@chakra-ui/react";
import {
  AppTab,
  AppTabList,
  AppTabNavItem,
  AppTabPanelParent,
  AppTabPanel,
} from "@/app/_components";
import { useMenuContext } from "@/app/_context";

import { useTabIndex } from "@/app/_includes/Header/components/_hooks";
import { useTabStyle } from "@/app/_components/AppTab/hooks";

import GridItems from "./_components/GridItems";
import GridChildren from "./_components/GridChildren";

export default function WhereToGoAndWhatToDo() {
  const [tabListRef, tablistStyleProps] = useTabStyle();
  const [link, tabIndex, setLink, setTabIndex] = useTabIndex();
  const { activeKey, data, hasChildren } = useMenuContext();

  const { menu } = data[activeKey];

  return (
    <AppTab
      defaultIndex={tabIndex}
      onChange={(index) => setTabIndex(index)}
      isLazy
    >
      <AppTabList
        ref={tabListRef}
        gap={{
          md: 4,
          lg: 12,
        }}
        pt={{
          md: 16,
        }}
        as={motion.div}
        initial={{ opacity: 0 }}
        animate={{ opacity: 1 }}
        exit={{ opacity: 0 }}
        {...tablistStyleProps}
      >
        {menu.map(({ _id, label, icon_url }) => (
          <AppTabNavItem
            key={_id}
            whiteSpace="nowrap"
            gap={2}
            color="black"
            pos="relative"
            px={{
              md: 8,
              lg: 0,
            }}
            _selected={{
              _before: {
                content: "''",
                pos: "absolute",
                bottom: 0,
                left: 0,
                h: 0.5,
                bg: "orangePeel.900",
                w: "full",
              },
            }}
          >
            <Image src={icon_url} width="32px" height="32px" alt={label} />
            <Box as="h6">{label}</Box>
          </AppTabNavItem>
        ))}
      </AppTabList>
      <AppTabPanelParent pt={8}>
        {menu.map(({ _id, subMenu, learn_more }) => (
          <AppTabPanel key={_id} px={0}>
            {subMenu && !link?.slug && (
              <GridItems
                subMenu={subMenu}
                learnMore={learn_more}
                onSetLink={setLink}
              />
            )}
            {hasChildren && link?.slug && (
              <GridChildren link={link} onBack={setLink} />
            )}
          </AppTabPanel>
        ))}
      </AppTabPanelParent>
    </AppTab>
  );
}
