import Link from "next/link";
import { shape, string, oneOf, func } from "prop-types";
import { useCallback } from "react";
import { useRouter } from "next-nprogress-bar";
import { motion } from "framer-motion";
import {
  Box,
  Heading,
  Flex,
  LinkBox,
  LinkOverlay,
  Link as ChakraLink,
} from "@chakra-ui/react";

import { SvgArrow } from "@/app/_components/Svg";
import { AppImage, AnimationWrapper } from "@/app/_components";

import { useMenuContext, useDispatchContext } from "@/app/_context";
import { pxToRem } from "@/app/_utils";
import { scaleVariant } from "@/app/_utils/animationVariants";

const MenuTitle = ({ type, title, parent, slug,handleNavigate }) => {

  let prnt;

 (type === "internal" || type === "link")
      ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL+'/'  
      : (type === "internal-other" )
      ? prnt=process.env.NEXT_PUBLIC_OLD_URL+'/'
      : prnt="" 
  
      
  let ur;
  parent ? ur=parent+'/'+slug : ur=slug

 let target;
  if (type === "external" || type === "internal-other" ) {
    target = 'target="_blank" rel="noopener noreferrer"';
  }

  return (
    <Box
      as="div"
      pos="absolute"
      bottom={0}
      p={{ md: "15px", lg: "30px" }}
      zIndex={2}
      cursor="pointer"
    >
      <Flex gap={2} align="center" justify="center">
        <Heading
          as="h4"
          color="white"
          fontSize="18"
          fontWeight="normal"
          overflow="hidden"
          sx={{
            display: "-webkit-box",
            WebkitLineClamp: "1",
            WebkitBoxOrient: "vertical",
          }}
        >
          {type === "internal" ? (
            title
          ) : (
            <Link href={`${prnt}${ur}`} passHref legacyBehavior>
              <LinkOverlay
                  title={title}
                  onClick={(e) => {
                    e.preventDefault();
                    handleNavigate();
                  }}
                  {...(type !== "internal" && { ...{ target } })}
                >
                  {title}
                </LinkOverlay>
            </Link>
          )}
        </Heading>
        <SvgArrow />
      </Flex>
    </Box>
  );
};

const MoreLink = ({ text, parent, slug , link }) => {
  const router = useRouter();
  const dispatch = useDispatchContext();
  const { activeKey } = useMenuContext();
  let prnt;
  (link.type === "internal" || link.type === "link")
       ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL+'/'  
       : (link.type === "internal-other" )
       ? prnt=process.env.NEXT_PUBLIC_OLD_URL+'/'
       : prnt=""   
       
   let ur;
   parent ? ur=parent+'/'+slug : ur=slug
 
  let target;
   if (link.type === "external" || link.type === "internal-other" ) {
     target = 'target="_blank" rel="noopener noreferrer"';
   }

   const handleCloseMenu = () => {
    dispatch({ type: "HANDLE_MEGA_MENU", value: false });
    dispatch({ type: "SET_ACTIVE_KEY", value: "" });
  
    if (activeKey === "where-to-go")
      dispatch({ type: "SET_CHILDREN", value: false });
  };
  

  const handleMoreNavigate = useCallback(() => {  
     
    if (link.type === "external" || link.type === "internal-other" ) {
      // Open the link in a new tab
      window.open(`${prnt}${ur}`, "_blank", "noopener,noreferrer");
    } else {
      handleCloseMenu();
      // Navigate to the link using router.push()
      router.push(`${prnt}/${ur}`);
    }
  }, [dispatch]);
   
  return (
    <Box
      pos="absolute"
      top="50%"
      textAlign="center"
      right={0}
      left={0}
      zIndex={2}
    >
      <Link href={`${prnt}${ur}`} passHref legacyBehavior>
        <ChakraLink
          variant="pill"
          color="white"
          borderColor="white"
          as={motion.a}
          onClick={(e) => {
            e.preventDefault();
            handleMoreNavigate();
          }}
          {...(link.type !== "internal" && { ...{ target } })}
        >
          {text}
          <SvgArrow />
        </ChakraLink>
      </Link>
    </Box>
  );
};

export default function MenuItem({
  image: { url, alt, base64 },
  link,
  title = "",
  type = "internal",
  transitionTiming,
  onSetLink = () => {}  
}) {
   const router = useRouter();
  const dispatch = useDispatchContext();

  const { activeKey } = useMenuContext();
  const { parent, slug } = link;
 
  const WrapperBox = ["internal", "more"].some((t) => t == type) ? Box : LinkBox;

  // Handle close the menu
  const handleCloseMenu = () => {
    dispatch({ type: "HANDLE_MEGA_MENU", value: false });
    dispatch({ type: "SET_ACTIVE_KEY", value: "" });

    if (activeKey === "where-to-go")
      dispatch({ type: "SET_CHILDREN", value: false });
  };
  //(activeKey === "where-to-go" && type==="link" && link.type!='internal') ? type=link.type : type=type

  let typemore=type;
  ((activeKey === "where-to-go" && type==="link" && link.type!='internal') || (type==="more")) 
  ? type=link.type 
  : type=type


  let prnt;
  let ur;   

  (type === "internal" || type === "link")
  ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL+'/'  
  : (type === "internal-other" )
  ? prnt=process.env.NEXT_PUBLIC_OLD_URL+'/'  
  : prnt="" 
  
  parent ? ur=parent+'/'+slug : ur=slug

  const handleNavigate = useCallback(() => {  
     
    if (activeKey === "where-to-go" && (type==='internal' || type==='internal-other' || type==='external'  )) { 
      
      if(type!='internal-other' &&  type!='external'){        
       onSetLink({ parent, slug }); }
      else{       
      window.open(`${prnt}${ur}`, "_blank", "noopener,noreferrer");
      }
    } 
    else { 
         
      if (type === "external" || type === "internal-other" ) {
        // Open the link in a new tab
        window.open(`${prnt}${ur}`, "_blank", "noopener,noreferrer");
      } else {
        handleCloseMenu();
        // Navigate to the link using router.push()
        router.push(`${prnt}/${ur}`);
      }
    }
  }, [dispatch]);

  return (
    <WrapperBox
      as={motion.div}
      initial={{ opacity: 0, y: 30 }}
      whileInView={{ opacity: 1, y: 0 }}
      viewport={{ once: true }}
      height={pxToRem(320)}
      borderRadius="10px"
      shadow="md"
      overflow="hidden"
      transition={`${transitionTiming}s`}
      onClick={(e) => handleNavigate(e)}
    >
      <AnimationWrapper
        cursor="pointer"
        variants={scaleVariant}
        _hover={{
          "svg path": {
            fill: "orangePeel.900",
          },
        }}
        h="full"
        borderRadius="10px"
        transition="0.3s linear"
        whileHover
        animateRoot
        overlay
      >
        <AppImage
          src={url}
          alt={alt}
          blurDataURL={base64}
          style={{
            width: "100%",
            objectFit: "cover",
          }}
          sizes="33vw"
          fill
        />

        {/* Menu Title Component */}
        {["default", "link", "internal", "internal-other", "external"].some((t) => t === type) && typemore != "more" && (
          <MenuTitle           
            type={type}
            title={title}
            parent={parent}
            slug={slug}          
            handleNavigate={handleNavigate}
          />
        )}

        {/* More Link Component */}
        {typemore === "more" && <MoreLink text={link.text} parent={parent} slug={slug} link={link} />}
      </AnimationWrapper>
    </WrapperBox>
  );
}

MenuItem.propTypes = {
  image: shape({
    url: string,
    alt: string,
  }).isRequired,
  link: shape({
    parent: string,
    slug: string,
    text: string,
  }).isRequired,
  title: string,
  type: oneOf(["default", "link", "more", "internal", "internal-other", "external"]),
  onSetLink: func,
};
