import { GridListWrapper } from "@/app/_includes/Header/components/_includes";
import { useMenuContext } from "@/app/_context";

import MenuItem from "./MenuItem";

export default function GridItems({ subMenu, learnMore, onSetLink }) {
  const { activeKey } = useMenuContext();
  return (
    <GridListWrapper>
      {subMenu.map(({ _id, label: title, image, link }, idx) => (

        <MenuItem
          key={_id}
          image={image}
          title={title}
          link={link}
          onSetLink={onSetLink}
         // type={activeKey === "where-to-go" ? "default" : link.type}
         type={link.type}
          transitionTiming={((idx + 1) / 2) * 0.3}
        />
      ))}
      {learnMore && (
        <MenuItem
          {...learnMore}
          type="more"
          link={learnMore.link}
          transitionTiming={((subMenu.length + 1) / 2) * 0.3}
        />
      )}
    </GridListWrapper>
  );
}
