import { Box, Heading, Text, Button } from "@chakra-ui/react";
import { motion } from "framer-motion";
import {
  GridListWrapper,
  ApiLoader,
  ApiError,
} from "@/app/_includes/Header/components/_includes";
import { SvgArrow } from "@/app/_components/Svg";

import { useSubMenuData } from "@/app/_includes/Header/components/_hooks";

import MenuItem from "./MenuItem";

export default function GridChildren({ link, onBack }) {
  const { slug } = link;
  const { subMenu, isLoading, error, isError } = useSubMenuData(true, slug);

  if (isLoading) return <ApiLoader />;

  if (isError) return <ApiError message={error.message} onBack={onBack} />;

  const {
    details: { title, description, items, learn_more },
  } = subMenu;

  return (
    <GridListWrapper>
      <Box
        pos="relative"
        display="flex"
        justifyContent="center"
        flexDir="column"
        textAlign="left"
        bg="white"
        shadow="md"
        p="5"
        borderRadius="md"
      >
        <Heading as="h4" color="black" fontSize="22" mb={5}>
          {title}
        </Heading>
        <Text as="p" mb={5} color="sage.900">
          {description}
        </Text>
        <Button
          variant="outline"
          as={motion.button}
          size="md"
          width="100px"
          borderColor="black"
          borderRadius="full"
          whileHover="hover"
          onClick={() => onBack({})}
          initial={false}
          _hover={{
            "svg path": {
              fill: "orangePeel.900",
            },
          }}
        >
          <SvgArrow direction="rtl" color="black" />
          &nbsp; Back
        </Button>
      </Box>
      {items.map(({ _id, title, image, link }, idx) => (
        <MenuItem
          key={_id}
          image={image}
          title={title}
          link={link}
          type="link"
          transitionTiming={((idx + 1) / 2) * 0.3}
        />
      ))}
      {learn_more && (
        <MenuItem
          {...learn_more}
          type="more"
          link={learn_more.link}
          transitionTiming={((items.length + 1) / 2) * 0.3}
        />
      )}
    </GridListWrapper>
  );
}
