import { SimpleGrid } from "@chakra-ui/react";
import { useMenuContext } from "@/app/_context";
import { menuKeys } from "@/app/_includes/Header/components/_data";
import { AnimationWrapper } from "@/app/_components";

import { InfoCard, CurrencyCard, DownloadAppCard, WeatherCard } from "./Cards";

const CardAnimateRoot = ({ children, transitionTiming }) => {
  return (
    <AnimationWrapper
      animateRoot
      overflow={false}
      initial={{ opacity: 0, y: 30 }}
      whileInView={{ opacity: 1, y: 0 }}
      viewport={{ once: true }}
      transition={`${transitionTiming}s linear`}
    >
      {children}
    </AnimationWrapper>
  );
};

export default function PlanYourTrip() {
  const {
    data: {
      plan_your_trip: { currencies,menu },
    },
  } = useMenuContext();

  return (
    <SimpleGrid
      spacing={6}
      pt={{
        md: 16,
        "2xl": 0,
      }}
      templateColumns={{
        md: "repeat(3, 1fr)",
        lg: "repeat(4, 1fr)",
      }}
    >
      {menuKeys.map((item, idx) => {
        let transitionTiming = ((idx + 1) / 2) * 0.1;

        switch (item) {
          case "currencies":
            return (
              <CardAnimateRoot key={item} transitionTiming={transitionTiming}>
                <CurrencyCard data={currencies} />
              </CardAnimateRoot>
            );          
          case "download_app":
            return (
              <CardAnimateRoot key={item} transitionTiming={transitionTiming}>
                <DownloadAppCard {...menu[item]} />
              </CardAnimateRoot>
            );
          default:
            return (
              <CardAnimateRoot key={item} transitionTiming={transitionTiming}>
                <InfoCard {...menu[item]} />
              </CardAnimateRoot>
            );
        }
      })}
    </SimpleGrid>
  );
}
