import Link from "next/link";
import {
  Text,
  Box,
  Button,
  Grid,
  GridItem,
  Flex,
  Image,
  LinkBox,
  LinkOverlay,
} from "@chakra-ui/react";
import { ReactSVG } from "react-svg";
import { BsApple, BsGooglePlay, BsArrowRightShort } from "react-icons/bs";
import {
  Card as DisplayCard,
  KtHeading,
  AppCarousel,
  EmblaContainer,
} from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";

export function InfoCard({ title, icon_url, link,type }) {
 let parent;
 let target;
 

 type === "internal"
        ? parent=process.env.NEXT_PUBLIC_APP_BASE_URL + link 
        : type === "internal-other"
        ? parent=process.env.NEXT_PUBLIC_OLD_URL + link 
        : parent=link
  
  type !== "internal" ? target='target="_blank" rel="noopener noreferrer"' : ""

  return (   

    <DisplayCard h="full">
      <LinkBox>
        <Flex
          direction="column"
          alignItems="center"
          justifyContent="space-between"
          h="full"
          gap={4}
        >
          <Image src={icon_url} width={140} height={140} alt={title} />
          <KtHeading
            as="h6"
            style={{
              fontSize: "18px",
            }}
          >
            <Link href={parent} passHref legacyBehavior>
              <LinkOverlay title={title} {...(type !== "internal" && { ...{ target } })} style={{
                display: "flex",
                alignItems: "center"
              }}  >
                {title}
                <BsArrowRightShort />
              </LinkOverlay>
            </Link>
          </KtHeading>
        </Flex>
      </LinkBox>
    </DisplayCard>
  );
}

export function CurrencyCard({ data }) {
  return (
    <DisplayCard h="full">
      <KtHeading
        as="h6"
        textAlign="center"
        style={{
          fontSize: "18px",
        }}
      >
        Currency 
      </KtHeading>
      <AppCarousel showDots dotPosition="bottom">
        <EmblaContainer>
          {data.map(({ _id, currency_type, inr_value }) => (
            <Box key={_id} flex="0 0 100%" minW={0} py={10}>
              <Grid templateColumns="repeat(12, 1fr)">
                <GridItem colSpan="3">
                  <Flex flexDirection="column">
                    <Text as="span" fontWeight="bold">
                      1
                    </Text>
                    <Text as="span">{currency_type}</Text>
                  </Flex>
                </GridItem>
                <GridItem colSpan="5">
                  <ReactSVG
                    src="/icons/currency.svg"
                    style={{
                      display: "flex",
                      justifyContent: "center",
                      marginBottom: "15px",
                    }}
                  />
                </GridItem>
                <GridItem colSpan="4">
                  <Flex flexDirection="column">
                    <Text as="span" fontWeight="bold">
                      {inr_value}
                    </Text>
                    <Text as="span">Rupee</Text>
                  </Flex>
                </GridItem>
              </Grid>
            </Box>
          ))}
        </EmblaContainer>
      </AppCarousel>
    </DisplayCard>
  );
}

/* export function WeatherCard() {
  return (
    <DisplayCard h="full">      
      
            
      <AppCarousel showDots dotPosition="bottom">
        <EmblaContainer>
        <Box flex="0 0 100%" minW={0} pb={10} pt={0}>
        <Grid templateColumns="repeat(12, 2fr)">
          <GridItem colSpan="12">
            <Flex flexDirection="column" gap={6}>
            <KtHeading as="h6">Thiruvanathapuram</KtHeading>
            <Flex gap={10} align="center">
              <ReactSVG src="/icons/weather.svg" />
              <Box
                display="flex"
                justifyContent="center"
                flexDirection="column"
                gap={1}
              >
                <Text
                  as="span"
                  fontSize={{
                    base: 50,
                  }}
                  lineHeight={1}
                >
                  {20}&#8451;
                </Text>
                <Text as="span" fontSize={appTextFontSize}>
                  Rain & Wind
                </Text>
              </Box>
            </Flex>
            <KtHeading
              as="h6"
              textAlign="center"
              style={{
                fontSize: "18px",
              }}
            >
              Weather
            </KtHeading>
            </Flex>
          </GridItem>
          </Grid>
        </Box>

        <Box flex="0 0 100%" minW={0} pb={10}>
        <Grid templateColumns="repeat(12, 2fr)">
          <GridItem colSpan="12">
            <Flex flexDirection="column" gap={6}>
            <KtHeading as="h6">Ernakulam</KtHeading>
            <Flex gap={10} align="center">
              <ReactSVG src="/icons/weather.svg" />
              <Box
                display="flex"
                justifyContent="center"
                flexDirection="column"
                gap={1}
              >
                <Text
                  as="span"
                  fontSize={{
                    base: 50,
                  }}
                  lineHeight={1}
                >
                  {20}&#8451;
                </Text>
                <Text as="span" fontSize={appTextFontSize}>
                  Rain & Wind
                </Text>
              </Box>
            </Flex>
            <KtHeading
              as="h6"
              textAlign="center"
              style={{
                fontSize: "18px",
              }}
            >
              Weather
            </KtHeading>
            </Flex>
          </GridItem>
          </Grid>
        </Box>
            
        </EmblaContainer>
      </AppCarousel> 
    </DisplayCard>
  );
} */

export function DownloadAppCard({ title, playStore, appleStore }) {
  return (
    <DisplayCard h="full">
      <Box
        display="inline-flex"
        justifyContent="space-between"
        alignItems="center"
        w="full"
        h="full"
        flexDir="column"
        gap={6}
      >
        <Box display="inline-flex" flexDir="column" gap={4} pt={6}>
          <Button
            variant="outline"
            fontSize="20px"
            gap={4}
            leftIcon={<BsApple />}
            as="a"
            href={appleStore.link}
            target="_blank"
            width="160px"
            height="50px"
            rounded="full"
            borderColor="black"
          >
            <Text as="span">IOS</Text>
          </Button>
          <Button
            as="a"
            fontSize="20px"
            gap={4}
            leftIcon={<BsGooglePlay />}
            variant="outline"
            href={playStore.link}
            target="_blank"
            width="160px"
            height="50px"
            rounded="full"
            borderColor="black"
          >
            <Text as="span">Android</Text>
          </Button>
        </Box>

        <KtHeading
          as="h6"
          style={{
            fontSize: "18px",
          }}
        >
          {title}
        </KtHeading>
      </Box>
    </DisplayCard>
  );
}
