import { forwardRef } from "react";
import { Button } from "@chakra-ui/react";
import { FiSearch, FiHeart, FiMenu, FiGlobe, FiDownloadCloud  } from "react-icons/fi";

const HeaderIcon = forwardRef(({ type = "", onClick }, ref) => {
  let icon = <FiMenu strokeWidth={1} />;
  if (type === "search") icon = <FiSearch strokeWidth={1} />;
  if (type === "fav") icon = <FiDownloadCloud strokeWidth={1} />;
  if (type === "language") icon = <FiGlobe strokeWidth={1} />;

  const ariaLabel = {
    ...(type === "search" && {
      "aria-label": "Search In Application"
    }),
    ...(type === "language" && {
      "aria-label": "Other Languages"
    }),    
    ...(type === "fav" && {
      "aria-label": "Your Favourites"
    }),
    ...(!type && {
      "aria-label": "View More Links"
    })
  }

  return (
    <Button
      bg="transparent"
      ref={ref}
      p={0}
      background="transparent"
      onClick={() => onClick()}
      _hover={{
        background: "transparent",
      }}
      sx={{
        svg: {
          base: {
            height: "20px",
            width: "20px",
          },
          md: {
            height: "24px",
            width: "24px",
          },
        },
      }}
      {...ariaLabel}
    >
      {icon}
    </Button>
  );
});

HeaderIcon.displayName = "HeaderIcon";

export default HeaderIcon;
