import Link from "next/link";
import { useRef } from "react";
import {
  Popover,
  PopoverTrigger,
  PopoverContent,
  PopoverHeader,
  PopoverArrow,
  PopoverCloseButton,
  PopoverBody,
  List,
  ListItem,
  Box,
  Flex,
  Text,
  Tag,
  Button,
  Link as ChakraLink,
} from "@chakra-ui/react";
import { FiHeart } from "react-icons/fi";
import HeaderIcon from "../HeaderIcon";
import { AppImage } from "@/app/_components";

import { staticFavData } from "../../../_data";

export default function Favourite() {
  const initialFocusRef = useRef();
  return (
    <Popover
      initialFocusRef={initialFocusRef}
      placement="bottom-end"
      closeOnBlur={false}
      isLazy
    >
      <PopoverTrigger>
        <HeaderIcon type="fav" />
      </PopoverTrigger>
      <PopoverContent
        color="white"
        bg="white"
        borderColor="aliceBlue.900"
        w={{ base: "300px", sm: "xs" }}
      >
        <PopoverHeader pt={4} color="black" fontWeight="bold" border="0">
          Your Favourites
        </PopoverHeader>
        <PopoverArrow bg="white" />
        <PopoverCloseButton bg="orangePeel.900" />
        <PopoverBody color="black" minH="60" maxH="60" overflowY="scroll">
          <List>
            {staticFavData.map(
              ({ _id, title, tags, image: { url, alt }, link }) => (
                <ListItem
                  key={_id}
                  pos="relative"
                  _notLast={{
                    pb: 4,
                  }}
                >
                  <Link href={link} passHref legacyBehavior>
                    <ChakraLink display="flex" alignItems="flex-start" w="full">
                      <Box width="95px" height="95px" pos="relative">
                        <AppImage
                          src={url}
                          alt={alt}
                          fill
                          sizes="30vw"
                          style={{
                            width: "100%",
                            height: "100%",
                            borderRadius: "10px",
                          }}
                        />
                      </Box>
                      <Box>
                        <Flex gap={2} pb={2}>
                          <Text fontWeight="semibold" fontSize="18px">
                            {title}
                          </Text>
                        </Flex>
                        <Flex gap={2}>
                          {tags.map((item) => (
                            <Tag variant="outline" key={item}>
                              {item}
                            </Tag>
                          ))}
                        </Flex>
                      </Box>
                    </ChakraLink>
                  </Link>
                  <Button
                    pos="absolute"
                    bg="transparent"
                    _hover={{
                      bg: "transparent",
                    }}
                    right={0}
                    top={0}
                    zIndex={5}
                    size="sm"
                    onClick={(e) => e.preventDefault()}
                    sx={{
                      svg: {
                        height: "20px",
                        width: "20px",
                        stroke: "orangePeel.900",
                      },
                      "svg path": {
                        fill: "orangePeel.900",
                      },
                    }}
                  >
                    <FiHeart />
                  </Button>
                </ListItem>
              )
            )}
          </List>
        </PopoverBody>
      </PopoverContent>
    </Popover>
  );
}
