import { useRef } from "react";
import { useDisclosure } from "@chakra-ui/react";
import { useMenuContext, useDispatchContext } from "@/app/_context";

import Sidebar from "./Sidebar";
import HeaderIcon from "../HeaderIcon";

export default function AppDrawer({ isMobile }) {
  const dispatch = useDispatchContext();
  const { isOpen: menuOpen, activeKey } = useMenuContext();
  const { isOpen, onOpen, onClose } = useDisclosure();
  const drawerRef = useRef(null);

  const handleOpenDrawer = () => {
    if (menuOpen) {
      dispatch({ type: "HANDLE_MEGA_MENU", value: false });
      dispatch({ type: "SET_ACTIVE_KEY", value: "" });

      if (activeKey === "where-to-go")
        dispatch({ type: "SET_CHILDREN", value: false });
    }

    onOpen();
  };

  return (
    <>
      <HeaderIcon ref={drawerRef} onClick={handleOpenDrawer} />
      <Sidebar
        isOpen={isOpen}
        onClose={onClose}
        ref={drawerRef}
        isMobile={isMobile}
      />
    </>
  );
}
