import { useCallback } from "react";
import { Button } from "@chakra-ui/react";
import { AppLink } from "@/app/_components";

import { useDispatchContext } from "@/app/_context";

export default function AppDrawerLink({ title, text, href, menuKey,type }) {
  const dispatch = useDispatchContext();

  const handleStaticMenuNavigation = useCallback(() => {
    let depth = 0;
    switch (menuKey) {
      case "where-to-go":
        depth = 3;
        break;
      case "what_to_do":
        depth = 2;
        break;
      default:
        depth = 1;
        break;
    }

    dispatch({ type: "SET_ACTIVE_KEY", value: menuKey });
    dispatch({ type: "SET_DEPTH", value: depth });
    dispatch({ type: "SET_ACTIVE_DEPTH", value: 1 });
  }, [menuKey, dispatch]);

  if(type!='') type=type; else type='internal';

  if (href === "#") {
    return (
      <Button
        p={6}
        borderBottom="1px"
        borderBottomColor="blackAlpha.400"
        borderRadius="none"
        variant="solid"
        display="flex"
        alignItems="center"
        justifyContent="flex-start"
        onClick={() => handleStaticMenuNavigation()}
      >
        {title}
      </Button>
    );
  }

  return (
    <AppLink
      py={4}
      px={6}
      color="black"
      bg="transperant"
      borderBottom="1px"
      borderBottomColor="blackAlpha.400"
      display="flex"
      alignItems="center"
      justifyContent="space-between"
      _hover={{
        "svg path": {
          fill: "orangePeel.900",
        },
      }}
      type={type}
      parent={href}
      title={title}
      arrow
    >
      {text}
    </AppLink>
  );
}
