"use client";

import { forwardRef, useEffect, useState} from "react";
import { AnimatePresence, motion } from "framer-motion";
import {
  Box,
  Drawer,
  DrawerOverlay,
  DrawerContent,
  DrawerCloseButton,
  DrawerHeader,
  DrawerBody,
} from "@chakra-ui/react";
import {
  DrawerContextProvider,
  useDispatchContext,
  useDrawerContext,
} from "@/app/_context";

import AppDrawerLink from "./_components/AppDrawerLink";
import MobileMenu from "./_components/MobileMenu";
import MenuChildren from "./_components/MenuChildren";


import { getArticleData } from "@/app/_libs/loadApi";

const DrawerLinks = ({ isMobile,sidebarMenus }) => {
  const dispatch = useDispatchContext();
  const { activeKey, activeDepth } = useDrawerContext();

  useEffect(() => {
    if (activeDepth === 0) {
      dispatch({ type: "SET_DEPTH", value: 0 });
      dispatch({ type: "SET_ACTIVE_KEY", value: "" });
      dispatch({ type: "SET_MENU_LIST", value: [] });
      dispatch({ type: "SET_LEARN_MORE", value: {} });
    }
  }, [activeDepth]);

  

  return (
    <AnimatePresence>
      {!activeKey ? (
        <Box
          as={motion.div}
          initial={{ opacity: 0 }}
          animate={{ opacity: 1 }}
          exit={{ opacity: 0 }}
          pt={5}
          display="flex"
          flexDir="column"
        >
          {isMobile && <MobileMenu />}
        
          {sidebarMenus.map(({ link, image, key }) => (
            <AppDrawerLink
              key={key}
              title={link.title}
              text={link.text}
              href={link.href}
              menuKey={key}
              type={link.type}
            />
          ))}
        </Box>
      ) : (
        <Box
          as={motion.div}
          initial={{ opacity: 0 }}
          animate={{ opacity: 1 }}
          exit={{ opacity: 0 }}
          pt={5}
          display="flex"
          flexDir="column"
        >
          <MenuChildren />
        </Box>
      )}
    </AnimatePresence>
  );
};

const Sidebar = forwardRef(({ isOpen, onClose, isMobile }, ref) => {

  const [sidebarMenus, setSidebarMenus] = useState([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const fetchSidebarMenus = async () => {
      try {
        const data = await getArticleData('burger-menu');
        setSidebarMenus(data);
      } catch (error) {
        console.error("Error fetching sidebar menus:", error);
      } finally {
        setLoading(false);
      }
    };

    fetchSidebarMenus();
  }, []);
  return (
    <Drawer
      isOpen={isOpen}
      placement="right"
      onClose={onClose}
      finalFocusRef={ref}
      closeOnOverlayClick={false}
    >
      <DrawerOverlay />
      <DrawerContent>
        <DrawerCloseButton
          bg="orangePeel.900"
          color="white"
          rounded="full"
          zIndex={5}
        />
        <DrawerHeader pb={8} />
        <DrawerBody paddingX={0}>
          <DrawerContextProvider>
          {loading ? (
              <p>Loading...</p>
            ) : (
              <DrawerLinks isMobile={isMobile} sidebarMenus={sidebarMenus}  />
            )}
           
          </DrawerContextProvider>
        </DrawerBody>
      </DrawerContent>
    </Drawer>
  );
});

Sidebar.displayName = "AppDrawer";

export default Sidebar;
