"use client";

import { useEffect, useState } from "react";
import {
  Box,
  Flex,
  UnorderedList,
  ListItem,
  Divider,
  Grid,
  GridItem,
  Text,
  Link,
  HStack,
} from "@chakra-ui/react";
import { KtContainer } from "@/app/_components";
import { ReactSVG } from "react-svg";

import { getArticleData } from "@/app/_libs/loadApi";


const socialLink = [
  {
    url: "https://www.facebook.com/keralatourismofficial",
    title: "facebook",
    svg: "/icons/facebook.svg",
  },
  {
    url: "http://twitter.com/keralatourism",
    title: "twitter",
    svg: "/icons/twitter-x.svg",
  },
  {
    url: "http://www.youtube.com/keralatourism",
    title: "youtube",
    svg: "/icons/youtube.svg",
  },
  {
    url: "https://www.instagram.com/keralatourism/?hl=en",
    title: "instagram",
    svg: "/icons/instagram.svg",
  },
  {
    url: "https://www.keralatourism.org/video-gallery/whatsapp",
    title: "whatsapp",
    svg: "/icons/whatsapp.svg",
  },
  {
    url: "https://in.pinterest.com/keralatourism/",
    title: "pinterest",
    svg: "/icons/pinterest.svg",
  },
  {
    url: "https://www.linkedin.com/company/keralatourism",
    title: "linkdein",
    svg: "/icons/linkedin.svg",
  },  
];

function Footer() {

  const [footList, setFootList] = useState([]);

  useEffect(() => {
    const fetchFooterData = async () => {
      try {
        const data = await getArticleData('footer-links');
       
        setFootList(data);
      } catch (error) {
        console.error("Error fetching footer data:", error);
      }
    };

    fetchFooterData();
  }, []);

  useEffect(() => {
    const script = document.createElement("script");
    script.src = "/assets/acc_toolbar_master/acctoolbar/acctoolbar.min.js";
    script.async = true;
    document.head.appendChild(script);

    script.onload = () => {
      window.micAccessTool = new MicAccessTool({
        link: "",
        contact: "mailto:info@keralatourism.org",
        buttonPosition: "left",
        forceLang: "en-EN",
      });
    };

    return () => {
      document.head.removeChild(script);
    };
  }, []);
  
  return (
    <Box
      as="footer"
      bg="black"
      mt={{
        base: 0,
        lg: 50,
      }}
      pt={50}
      pb={50}
    >
      <KtContainer maxW="container.xl">
        <Box maxW="lg" m="auto" textAlign="center">
          <Flex align="center" justify="center" pb={8}>
            <UnorderedList styleType="none" margin="0">
              {footList.map(({ title,link,type }, key) => (
               
                <ListItem
                  _notFirst={{
                    _before: {
                      content: '""',
                      pos: "absolute",
                      height: "12px",
                      width: "1px",
                      left: "0",
                      top: "8px",
                      backgroundColor: "whiteAlpha.500",
                    },
                  }}
                  key={key}
                  display="inline-flex"
                  pos="relative"
                  px={2}
                  m={1}
                >
                 <Link href={type === "internal"
                  ? process.env.NEXT_PUBLIC_APP_BASE_URL +link 
                  : type === "internal-other"
                  ? process.env.NEXT_PUBLIC_OLD_URL + link 
                  : link} target={type!='internal' ? "_blank" : ''} title={title}>{title}</Link>
                </ListItem>
              ))}
            </UnorderedList>
          </Flex>
        </Box>

        <Divider borderBottomColor="gray.500" />

        <Grid
          templateColumns={{ base: "repeat(1, 1fr)", md: "repeat(2, 1fr)" }}
          gridAutoFlow={{
            base: "row",
            sm: "column",
            md: "column",
          }}
          placeItems={{
            base: "start",
            sm: "center",
            md: "end",
          }}
          gap={2}
          alignItems="center"
          pt={2}
        >
          <GridItem w="100%">
            {/* <Flex>
              <Text as="span">Legal</Text>
              <Divider
                orientation="horizontal"
                w="1px"
                h="22px"
                m="0 10px"
                bgColor="gray.500"
              />
              <Text as="span">Imprint</Text>
            </Flex> */}
            <Flex>
              <Text>All rights reserved © Kerala Tourism</Text>
            </Flex>
          </GridItem>
          <GridItem>
            <HStack justify="end" align="center">
              {socialLink.map(({ title, url, svg }, key) => (
                <Link
                  key={key}
                  title={title}
                  href={url}
                  target="_blank"
                  padding="0"
                  height="48px"
                  width="48px"
                  borderRadius="50%"
                  border="1px"
                  bg="transparent"
                  justifyContent="center"
                >
                  <ReactSVG src={svg} />
                </Link>
              ))}
            </HStack>
          </GridItem>
        </Grid>
      </KtContainer>
    </Box>
  );
}

export default Footer;
