import { Flex } from "@chakra-ui/react";
import { KtHeading } from "@/app/_components";

export default function FormWrapper({ formHeading, children }) {
  return (
    <Flex
      gap={{
        base: 4,
        lg: 6
      }}
      direction="column"
      justify="center"
      h="full"
      px={{
        base: 8,
        md: 16,
        lg: 12,
        xl: 32,
      }}
      py={{
        base: 8,
        md: 8,
        lg: 4,
        xl: 16,
      }}
    >
      <KtHeading as="h2">{formHeading}</KtHeading>
      {children}
    </Flex>
  );
}
