import {
  Box,
  Grid,
  GridItem,
  Flex,
  Text,
  useMediaQuery,
} from "@chakra-ui/react";
import { useConfigurationContext } from "@/app/_context";

import {
  AppModal,
  AppImage,
  KtHeading,
  AnimationWrapper,
} from "@/app/_components";

const AuthBgImage = ({ alt, url, base64 }) => {
  return (
    <AppImage
      alt={alt}
      height={950}
      width={950}
      src={url}
      blurDataURL={base64}
      style={{ width: "100%", height: "100%" }}
    />
  );
};

export default function AuthModal({ isOpen, handleClose, bgKey, children }) {
  const [isMedium] = useMediaQuery(["(max-width: 991px)"]);
  const { data } = useConfigurationContext();

  return (
    <AppModal
      modalProps={{
        maxW: {
          base: "95%",
          lg: "90%",
          xl: "80%",
        },
        maxH: {
          base: "100%",
        },
      }}
      modalBodyProps={{ p: 0, borderRadius: "lg" }}
      closeBtnProps={{
        zIndex: 99,
        pos: "absolute",
        top: "8px",
        right: "10px",
        color: "white",
        bg: "transperant",
        borderWidth: "1px",
        borderColor: "white",
        borderRadius: "full",
        sx: {
          "svg path": {
            fill: "orangePeel.900",
          },
        },
      }}
      isOpen={isOpen}
      onClose={handleClose}
      hasOverLay
    >
      <Grid
        templateColumns={{
          md: "repeat(1, 1fr)",
          lg: "repeat(2, 1fr)",
        }}
        sx={{
          "@media screen and (max-width: 991px)": {
            ".intro__image__area": {
              display: "none",
            },
          },
        }}
      >
        {children}
        {!isMedium && (
          <GridItem className="intro__image__area" pos="relative">
            <AnimationWrapper
              overflow={false}
              animateRoot
              overlay
              overlayType="light"
              h="full"
            >
              <Box pos="absolute" p={16} w="full" top={8} zIndex={1}>
                <Flex direction="column" gap={6}>
                  <KtHeading as="h3" color="white">
                    Welcome to <br /> Kerala Tourism
                  </KtHeading>
                  <Text fontSize="16px" color="white">
                    There’s something for every traveller in Kerala.
                  </Text>
                </Flex>
              </Box>
              {data && <AuthBgImage {...data[bgKey].image} />}
            </AnimationWrapper>
          </GridItem>
        )}
      </Grid>
    </AppModal>
  );
}
