"use client";
import React, { useState} from "react";
import { ReactSVG } from "react-svg";
import { Flex, FormControl, FormLabel, Input, Text } from "@chakra-ui/react";

import { useAuthContext, useDispatchContext } from "@/app/_context";
import { AppButton } from "@/app/_components";

import AuthModal from "./_components/AuthModal";
import FormWrapper from "./_components/FormWrapper";
import Swal from 'sweetalert2';


export default function SignUp() {

  const [name, setName] = useState("");
  const [email, setEmail] = useState(""); 
  const [mobile, setMobile] = useState("");
  const [password, setPassword] = useState(""); 
  const [cpassword, setcPassword] = useState(""); 
  

  const { isOpenSignUp } = useAuthContext();
  const dispatch = useDispatchContext();

  const handleCloseSignUp = () => {
    dispatch({ type: "HANDLE_SIGNUP_MODAL", value: false });
  };

  const handleOpenSignIn = () => {
    handleCloseSignUp();
    dispatch({ type: "HANDLE_SIGNIN_MODAL", value: true });
  };

  
  const authHeaders = {
    Authorization: `Bearer ${process.env.NEXT_PUBLIC_AUTHORIZATION_KEY}`,
    'Content-Type': `application/json`
  };
  
  const getSignUp = async (slug) => {    
  const response = await fetch(`${process.env.NEXT_PUBLIC_KT_BRIDGE_URL}auth/signup`, {   
    headers: authHeaders,
    credentials: 'include',
    cache: "no-store",
    method: "POST",
    body: JSON.stringify(slug)
  });

  if (response.status === 404) {
    return notFound();
  }
  if (response.status === 201) {
    return response;
  }
  else{
    return response;
  }
    
};

  const handleSignUp = async() => { 
    if (name.trim() == '') {
      Swal.fire({
        icon: 'info',
        title: 'Name is required.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });       
      return false;         
    }  
    else if (!/^[a-zA-Z0-9\s]+$/.test(name)) {  
      Swal.fire({
        icon: 'error',
        title: 'Invalid name. Please use only letters, numbers, and spaces.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });     
      //alert("Invalid name. Please use only letters, numbers, and spaces.");
      return false;    
    }

    if (email.trim() == '') { 
      Swal.fire({
        icon: 'info',
        title: 'Email is required.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });       
        return false;  
    } else if (!/\S+@\S+\.\S+/.test(email)) {  
      Swal.fire({
        icon: 'error',
        title: 'Email is invalid.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });     
        return false;
    } 

    if (mobile.trim() == '') { 
      Swal.fire({
        icon: 'info',
        title: 'Mobile is required.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });       
        return false;  
    } 
    else if (mobile.trim() == 0) { 
      Swal.fire({
        icon: 'info',
        title: 'Mobile is invalid.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });       
        return false;  
    }  else if (!/^[0-9\s]+$/.test(mobile)) {   
      Swal.fire({
        icon: 'error',
        title: 'Mobile is invalid.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });     
        return false;
    } 
    
    if (password.trim() == '') { 
      Swal.fire({
        icon: 'info',
        title: 'Password is required.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });       
        return false;  
    }
    if (cpassword.trim() == '') { 
      Swal.fire({
        icon: 'info',
        title: 'Confirm Password is required.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });       
        return false;  
    }
    if (password.trim() != cpassword.trim()) { 
      Swal.fire({
        icon: 'info',
        title: 'Password mismatch.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });       
        return false;  
    }
      
       const submitData = {name,email,mobile,password}
      
   const response= await getSignUp(submitData); 
   
   const data = await response.json();
   
    if (response.status == 201) {
      Swal.fire({
        icon: 'success',
        title: 'SignUp Successfully.An activation link is send to your given email',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });
      setName('');
      setMobile('');
      setEmail('');
      setPassword('');
      setcPassword('');
    } else {
      Swal.fire({
        icon: 'error',
        title: data.message,
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });
    }
}; 

  return (
    <AuthModal
      isOpen={isOpenSignUp}
      handleClose={handleCloseSignUp}
      bgKey="signUpBg"
    >
      <FormWrapper formHeading="Sign Up">
        <Flex
          pt={4}
          gap={{
            base: 4,
            lg: 6,
            xl: 6,
          }}
          direction="column"
        >
          {/* {signUpFormInputs.map(({ id, label, ...restInputProps }) => ( */}
            <FormControl >
              <FormLabel>Name</FormLabel>
              <Input
                variant="flushed"
                focusBorderColor="orangePeel.900"
                value={name}
                onChange={(e) => setName(e.target.value)}
              />
              <FormLabel>Email</FormLabel>
              <Input
                variant="flushed"
                focusBorderColor="orangePeel.900"
                value={email}
                onChange={(e) => setEmail(e.target.value)}
              />
              <FormLabel>Mobile</FormLabel>
              <Input
                variant="flushed"
                focusBorderColor="orangePeel.900"
                value={mobile}
                onChange={(e) => setMobile(e.target.value)}
              />
              <FormLabel>Password</FormLabel>
              <Input
                variant="flushed"
                focusBorderColor="orangePeel.900"
                value={password}
                type="password"
                onChange={(e) => setPassword(e.target.value)}
              />
              <FormLabel>Confirm Password</FormLabel>
              <Input
                variant="flushed"
                focusBorderColor="orangePeel.900"
                value={cpassword}
                type="password"
                onChange={(e) => setcPassword(e.target.value)}
              />
            </FormControl>
       {/*    ))} */}
          <Flex
            direction="column"
            gap={{
              base: 4,
            }}
          >
            <AppButton onClick={() => { handleSignUp(); }}>Sign Up</AppButton>
            <AppButton variant="none" onClick={() => handleOpenSignIn()}>
              Sign In
            </AppButton>
          </Flex>
          {/* <Flex gap={4} direction="column" align="center">
            <Text fontSize="16px">Or Sign up with Google Account</Text>
            <ReactSVG
              src="/images/Auth/google.svg"
              style={{ cursor: "pointer" }}
            />
          </Flex> */}
        </Flex>
      </FormWrapper>
    </AuthModal>
  );
}
