"use client";
import React, { useState,useCallback } from "react";

import { ReactSVG } from "react-svg";
import { Flex, FormControl, FormLabel, Input, Text } from "@chakra-ui/react";
import { useAuthContext, useDispatchContext } from "@/app/_context";
import { AppButton } from "@/app/_components";
import { useRouter } from "next-nprogress-bar";


import AuthModal from "./_components/AuthModal";
import FormWrapper from "./_components/FormWrapper";
import { notFound } from "next/navigation";
import Swal from 'sweetalert2';


export default function SignIn() {
  
  const router = useRouter();
  const [email, setEmail] = useState(""); 
  const [password, setPassword] = useState("");
  const [forgotPassword, setForgotPassword] = useState(false);
  const { isOpenSignIn } = useAuthContext();
  const dispatch = useDispatchContext();
 
  // Function for close sign in modal
  const handleCloseSignIn = useCallback(() => {
    dispatch({ type: "HANDLE_SIGNIN_MODAL", value: false });
  }, []);

  // Function for open sign up modal
  const handleOpenSignUp = useCallback(() => {
    dispatch({ type: "HANDLE_SIGNUP_MODAL", value: true });
  }, []);

  const authHeaders = {
    Authorization: `Bearer ${process.env.NEXT_PUBLIC_AUTHORIZATION_KEY}`,
    'Content-Type': `application/json`
  };

const getResponse = async (slug,url) => {    
  const response = await fetch(`${process.env.NEXT_PUBLIC_KT_BRIDGE_URL}${url}`, {   
    headers: authHeaders,
    credentials: 'include',
    cache: "no-store",
    method: "POST",
    body: JSON.stringify(slug)
  });

  if (response.status === 404) {
    return response;
  }
  if (response.status === 201) {
    return response;
  }
  else{
    return response;
  }
    
};

  const handleSignIn = async() => { 
  
    if (email.trim() == '') { 
      Swal.fire({
        icon: 'info',
        title: 'Email is required.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });       
        return false;  
    } else if (!/\S+@\S+\.\S+/.test(email)) {  
      Swal.fire({
        icon: 'error',
        title: 'Email is invalid.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });     
        return false;
    } 
    
    if (password.trim() == '') { 
      Swal.fire({
        icon: 'info',
        title: 'Password is required.',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });       
        return false;  
    }
     const submitData = {email,password}
      
    const response= await getResponse(submitData,'auth/login'); 
   const data = await response.json();  
    
    if (response.status == 200) {
      Swal.fire({
        icon: 'success',
        title: 'SignIn Successfully',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });
      setEmail('');
      setPassword('');
      handleCloseSignIn();
      router.push("/destination/munnar/202/");
    } else {
      Swal.fire({
        icon: 'error',
        title: data.message,
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });
    }  
}; 

const handleForgotPasswordSubmit = async () => {
  if (email.trim() === '') {
    Swal.fire({
      icon: 'info',
      title: 'Email is required.',
      didOpen: () => {
        const swalContainer = Swal.getContainer();
        swalContainer.style.zIndex = 9999;
      }
    });
    return false;
  } else if (!/\S+@\S+\.\S+/.test(email)) {
    Swal.fire({
      icon: 'error',
      title: 'Email is invalid.',
      didOpen: () => {
        const swalContainer = Swal.getContainer();
        swalContainer.style.zIndex = 9999;
      }
    });
    return false;
  }
  
  const submitData = {email}
      
   const response= await getResponse(submitData,'auth/forgot_password'); 
   const data = await response.json();
   
    if (response.status == 200) {
      Swal.fire({
        icon: 'success',
        title: 'Password reset link sent',
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });
      setEmail('');
      setForgotPassword(false);
    } else {
      Swal.fire({
        icon: 'error',
        title: data.message,
        didOpen: () => {
          const swalContainer = Swal.getContainer();
          swalContainer.style.zIndex = 9999;
        }
      });
    } 
};
function LoginButton() {
  const { pending } = useFormStatus()
 
  const handleClick = (event) => {
    if (pending) {
      event.preventDefault()
    }
  }
 
  return (
    <button aria-disabled={pending} type="submit" onClick={handleClick}>
      Login
    </button>
  )
}
  return (
      <AuthModal
        isOpen={isOpenSignIn}
        handleClose={handleCloseSignIn}
        bgKey="signInBg"
      >
        <FormWrapper formHeading={forgotPassword ? "Forgot Password" : "Sign In" }>
          <Flex
            pt={{
              base: 4,
              lg: 8,
            }}
            gap={8}
            direction="column"
          >
          
              <FormControl >
                 {!forgotPassword ? (
              <>
                <FormLabel htmlFor="Email">Email</FormLabel>
                <Input
                  variant="flushed"
                  focusBorderColor="orangePeel.900"
                
                value={email}
                onChange={(e) => setEmail(e.target.value)}
                />

              <FormLabel htmlFor="Email">Password</FormLabel>
                <Input
                  variant="flushed"
                  focusBorderColor="orangePeel.900"
                  type="password"
                value={password}
                onChange={(e) => setPassword(e.target.value)}
                />

                <Flex justify="flex-end" pt={4}>
                  <Text fontSize="16px" color="#DB7676" cursor="pointer" onClick={() => setForgotPassword(true)}>
                    Forget Password?
                  </Text>
                </Flex>
                </>
            ) : (
              <>
                <FormLabel htmlFor="Email">Enter your Email</FormLabel>
                 <Input
                  variant="flushed"
                  focusBorderColor="orangePeel.900"
                  value={email}
                  onChange={(e) => setEmail(e.target.value)}
                /> 
                <AppButton onClick={handleForgotPasswordSubmit}>
                  Submit
                </AppButton>
                <Text
                  fontSize="16px"
                  color="#DB7676"
                  cursor="pointer"
                  onClick={() => setForgotPassword(false)}
                >
                  Back to Sign In
                </Text>
              </>
            )}
              </FormControl>
              {!forgotPassword && (
                <>
                <Flex
                  direction="column"
                  gap={{
                    base: 4,
                  }}
                >
                
                  <AppButton onClick={() => { handleSignIn(); }}>
                  Sign in
                    </AppButton>
                  <AppButton
                    variant="none"
                    onClick={() => {
                      handleCloseSignIn();
                      handleOpenSignUp();
                    }}
                  >
                    Sign up
                  </AppButton>
                </Flex>
                {/* <Flex
                  gap={{
                    base: 2,
                    lg: 4,
                  }}
                  direction="column"
                  align="center"
                >
                  <Text fontSize="16px">Or Sign in with Google Account</Text>
                  <ReactSVG
                    src="/images/Auth/google.svg"
                    style={{ cursor: "pointer" }}
                  />
                </Flex> */}
                </>
             )}
          </Flex>
        </FormWrapper>
      </AuthModal>
  );
}
