function authReducer(state, action) {
  switch (action.type) {
    case "HANDLE_SIGNUP_MODAL":
      return {
        ...state,
        isOpenSignUp: action.value,
      };
    case "HANDLE_SIGNIN_MODAL":
      return {
        ...state,
        isOpenSignIn: action.value,
      };
    default:
      throw new Error(`Unhandled action ${action.type}`);
  }
}

function menuReducer(state, action) {
  switch (action.type) {
    case "HANDLE_SEARCH_MODAL":
      return {
        ...state,
        isOpenSearch: action.value,
      };
    case "HANDLE_MEGA_MENU":
      return {
        ...state,
        isOpen: action.value,
      };
    case "SET_CHILDREN":
      return {
        ...state,
        hasChildren: action.value,
      };
    case "SET_ACTIVE_KEY":
      return {
        ...state,
        activeKey: action.value,
      };
    default:
      throw new Error(`Unhandled action ${action.type}`);
  }
}

function drawerReducer(state, action) {
  switch (action.type) {
    case "SET_ACTIVE_KEY":
      return {
        ...state,
        activeKey: action.value,
      };
    case "SET_DEPTH":
      return {
        ...state,
        depth: action.value,
      };
    case "SET_ACTIVE_DEPTH":
      return {
        ...state,
        activeDepth: action.value,
      };
    case "SET_MENU_LIST":
      return {
        ...state,
        menuList: action.value,
      };
    case "SET_LEARN_MORE":
      return {
        ...state,
        learnMore: action.value,
      };
    case "SET_SELECTED_ID":
      return {
        ...state,
        selectedId: action.value,
      };
    case "SET_PREVIOUS_ID":
      return {
        ...state,
        prevId: action.value,
      };
    case "SET_SLUG":
      return {
        ...state,
        slug: action.value,
      };
    default:
      throw new Error(`Unhandled action ${action.type}`);
  }
}

function lightBoxReducer(state, action) {
  switch (action.type) {
    case "SET_ACTIVE_KEY":
      return {
        ...state,
        activeKey: action.value,
      };
    case "SET_ACTIVE_INDEX":
      return {
        ...state,
        activeIndex: action.value,
      };
    case "SET_DIRECTION":
      return {
        ...state,
        direction: action.value,
      };
    default:
      throw new Error(`Unhandled action ${action.type}`);
  }
}

export { authReducer, drawerReducer, lightBoxReducer, menuReducer };
