/**
 * Applicaton Header
 */
export const APP_HEADER = "header";

/**
 * Application Portfolio
 */
export const APP_PORTFOLIO = "portfolio";

/**
 * Application Footer
 */
export const APP_FOOTER = "footer";

/**
 * App Section Heading
 */
export const SECTION_HEADING = "section_heading";

/**
 * Application Root Component Types
 */
export const COMPONENT_TYPES = Object.freeze({
  ACCOMODATION: "accomodation",
  BANNER: "banner",
  SLIDER: "slider",
  ESSENTIAL: "essential",
  EVENTCALENDAR: "event_calendar",
  HIGHLIGHT_STORY: "highlight_bg_story",
  LIST: "list",
  SUBSCRIPTION: "subscription",
  VIDEO_PLAYER: "video_player",
  TOP_HEADING: "top_heading",
  GRID_LIST: "grid_list",
  GRID: "grid",
  FILTER: "filter",
  ARTICLE: "article",
  TRAVEL_INFO: "travel_info",
  GALLERY_GRID: "gallery_grid",
  EBROCHURE: "ebrochure",
  HIGHLIGHT_CARD: "highlight_card",
  PROFILE: "profile",
  GALLERY: "gallery",
});

/**
 * Application Banner Catgories
 */
export const BANNER_CATEGORIES = Object.freeze({
  MAIN_BANNER: "main",
  SUB_BANNER: "sub",
  ARTICLE_BANNER: "article",
  ARTICLE_VIDEO_BANNER: "article_video",
  VIDEO_BANNER: "video_banner",
  MICRO_SITE_BANNER: "micro",
});

/**
 * Application List Categories
 */
export const LIST_CATEGORIES = Object.freeze({
  DEFAULT_LIST: "default",
  INFOCARD_LIST: "info_card",
  TOURGUIDE_CARD: "tour_guide_card",
  DESTINATION_LIST: "destination",
  PORTFOLIO_LIST: "portfolio_card",
  PACKAGE_LIST: "packages",
  TRAVEL_TIPS_LIST: "travel_tip",
  NEWS_LIST: "news_list",
  MAJOR_LIST: "major",
});

/**
 * Application Slider Categories
 */
export const SLIDER_CATEGORIES = Object.freeze({
  MAIN_SLIDER: "main",
  WHATS_NEW_SLIDER: "whats_new",
  VIDEO_BG_ACTIVITY_SLIDER: "video_bg_activity",
  USERS_STORY_SLIDER: "users_story",
  EVENT_SLIDER: "event",
  PHOTO_GALLERY_SLIDER: "photo_gallery",
  PHOTO_VIDEO_GALLERY: "photo_video_gallery",  
  VIDEO_GALLERY_SLIDER: "video_gallery",
  ACTIVITY_SLIDER: "activity",
  RELATED_ACTIVITY_SLIDER: "related_activities",
  TOUR_GUIDE_SLIDER: "tour_guide",
  DESTINATION_SLIDER: "destination",
  CUSTOMER_REVIEW_SLIDER: "customer_reviews",
  INFORMATION_SLIDER: "info",
  EBROUCHURE_SLIDER: "ebrochure",
  EBROCHURES_SLIDER: "ebrochures",
  PORTFOLIO_SLIDER: "portfolio",
  STORY_SLIDER: "stories",
  TOUR_PACKAGE_SLIDER: "tour_packages",
  DISTRICT_SLIDER: "district_gallery"
});

/**
 * Application Filter List Categories
 */
export const FILTER_LIST_CATEGORIES = Object.freeze({
  DEFAULT_FILTER_LIST: "default",
  INFO_FILTER_LIST: "info",
  TOUR_GUIDE_FILTER_LIST: "tour_guide",
  EBROCHURE_FILTER_LIST: "ebrochure",
  WHERE_TO_STAY_FILTER_LIST: "where_to_stay",
});

/**
 * User Profile Categories
 */
export const PROFILE_CATEGORIES = Object.freeze({
  PROFILE_INFO: "info",
  UPLOAD_STORY: "upload_story",
});

/**
 * Application Filter Items
 */
export const FILTER_FOR = Object.freeze({
  DESTINATION: "destination",
  ARTFORMS: "artforms",
  CUISINE: "cuisine",
  SOUVENIRS: "souvenirs",
  SOUVENIRS_SHOPS: "souvenirs_shops",
  EBROCHURES: "ebrochures",
  WHERE_TO_STAY: "where_to_stay",
  TOUR_GUIDE: "tour_guides",
});

/**
 * Application Article Categories
 */
export const ARTICLE_CATEGORIES = Object.freeze({
  DETAILS: "details",
  EBROCHURE_ARTICLE: "ebrochure",
});
