"use client";

import dynamic from "next/dynamic";
import { Box } from "@chakra-ui/react";
import {
  KtContainer,
  AppSection,
  AppLink,
  SectionHeading,
} from "@/app/_components";

const AppPlayer = dynamic(() =>
  import("@/app/_components").then((mod) => mod.AppPlayer)
);

export default function VideoPlayer({
  _id = "",
  heading,
  description,
  url,
  poster_image,
  link: { text, ...restLinkProps },
  scroll_key = ""
}) {
  const sectionId = scroll_key != "" ? scroll_key : _id;
  return (
    <AppSection  id={sectionId} explore>
      <KtContainer maxW="container.2xl">
        {(heading || description) && (
          <Box maxW="container.xl" mx="auto">
            <SectionHeading heading={heading} description={description} />
          </Box>
        )}
        <AppPlayer url={url} poster_image={poster_image} type="youtube">
          <Box as="div" pos="absolute" right="0" bottom="-50px">
            <AppLink
              {...restLinkProps}
              color="black"
              variant="pill"
              arrow
            >
              {text}
            </AppLink>
          </Box>
        </AppPlayer>
      </KtContainer>
    </AppSection>
  );
}
