"use client";

import { useState,useEffect, memo } from "react";

import { Box, Text, useMediaQuery, Skeleton } from "@chakra-ui/react";

import {
  useJsApiLoader,
  GoogleMap,
  Marker,
  InfoWindow,
} from "@react-google-maps/api";

import {
  KtContainer,
  AppSection,
  SectionHeading,
  AppTab,
  AppTabIndicator,
  AppTabList,
  AppTabNavItem,
  AppTabPanelParent,
  AppTabPanel,
} from "@/app/_components";

import { appTextFontSize } from "../../_styles";

const GoogleMapMemoized = memo(function Map({ locations, tabIndex}) {
  const [activeMarker, setActiveMarker] = useState("");
  return (
    <Box
      h={{
        base: "50vh",
        lg: "70vh",
      }}
    >
    
      <GoogleMap
  mapContainerStyle={{ height: "100%", width: "100%" }}
  center={locations.length > 0 ? locations[0].location : { lat: 0, lng: 0 }}
  zoom={5}
  onLoad={(map) => {
    const bounds = new window.google.maps.LatLngBounds();
    locations.forEach(({ location }) => {
      bounds.extend(new window.google.maps.LatLng(location.lat, location.lng));
    });
    map.fitBounds(bounds);
  }}
>
  {locations.map(({ _id, name, location }) => (
    <Marker
      key={tabIndex}
      position={location}
      onClick={() => setActiveMarker(_id)}
    >
      {activeMarker === _id && (
        <InfoWindow
          position={location}
          clickable={true}
          onCloseClick={() => setActiveMarker("")}
        >
          <Text>{name}</Text>
        </InfoWindow>
      )}
    </Marker>
  ))}
</GoogleMap>
    </Box>
  );
});

export default function TravelInfo({
  _id,
  scroll_key = "",
  heading,
  description,
  items,
}) {
  
  const [currentTabIndex, setCurrentTabIndex] = useState(0);
  const sectionId = scroll_key != "" ? scroll_key : _id;
  const [isMobile] = useMediaQuery(["(max-width: 479px)"]);

  const { isLoaded } = useJsApiLoader({
    id: "google-map-script",
    googleMapsApiKey: "AIzaSyDfENGM_enZP-BU4E0v3lJ-uOAaUEwXlyg",
  });
   // Define handleTabChange outside the return statement
 const handleTabChange = (index) => {
  setCurrentTabIndex(index);
  // Additional logic if needed on tab change
};


  //   // Use useEffect to set the active marker when the component mounts
  // useEffect(() => {
  //   setCurrentTabIndex(1);
  // }, []);

  return (
    <AppSection id={sectionId}>
      <KtContainer>
        {(heading || description) && (
          <SectionHeading heading={heading} description={description} />
        )}
        <AppTab
          align={isMobile ? "start" : "center"}
          sx={{
            "@media screen (max-width: 479px)": {
              ".tab__indicator": {
                display: "none",
              },
            },
            "@media screen (min-width: 478px)": {
              ".tab__indicator": {
                display: "block",
              },
            },
          }}
        >
          <AppTabList
            gap={{
              base: 4,
              md: 12,
            }}
            overflowX="auto"
          >
            {items.map(({ _id, title }) => (
              <AppTabNavItem
                px="0"
                fontSize={appTextFontSize}
                key={_id}
                pb="4"
                fontWeight="bold"
                color="black"
                {...(isMobile && {
                  _selected: {
                    color: "orangePeel.900",
                  },
                })}
                whiteSpace="nowrap"
                onClick={() => handleTabChange(_id)}
              >
                {title}
              </AppTabNavItem>
            ))}
          </AppTabList>
          {!isMobile && (
            <AppTabIndicator className="tab__indicator" align="center" />
          )}
          <AppTabPanelParent pt={{ base: 4, md: 0 }}>
            {items.map(({ _id, locations }) => (
              <AppTabPanel p={0} key={_id}>
                {isLoaded ? (
                  <GoogleMapMemoized locations={locations}  tabIndex={currentTabIndex} />
                ) : (
                  <Skeleton>
                    <Box
                      h={{
                        base: "50vh",
                        lg: "70vh",
                      }}
                    />
                  </Skeleton>
                )}
              </AppTabPanel>
            ))}
          </AppTabPanelParent>
        </AppTab>
      </KtContainer>
    </AppSection>
  );
}
