"use client";
import React, { useState } from "react";
import { Grid, GridItem, Input,FormControl, Button } from "@chakra-ui/react";

import { AppSection, KtContainer, SectionHeading, AppButton } from "@/app/_components";
import { validateSubscription } from "./Validate_form";


//import { validateSubscription } from "@/app/_libs";

const Subscription_form = () => {

    const [first_name, setFirst_name] = useState("");
    const [email, setEmail] = useState(""); 

    const handleSubscription = async() => {   
       const rslt= await validateSubscription(first_name,email);    
       console.log(rslt);
    }; 

  return (
    <AppSection pb="50px">
      <SectionHeading
        heading="Subscribe to our newsletter"
        description="Sign up for Kerala Tourism's monthly newsletter to learn about our events, offers and more…"
      />
      <KtContainer maxW="container.lg">
        <FormControl>
          <Grid
            templateColumns="repeat(12, 1fr)"
            columnGap={{  base: 0, md: 4, lg: 5 }}
            rowGap={{ base: 8, md: 0}}
          >
            <GridItem
              colSpan={{
                base: "12",
                sm: "12",
                md: "5",
              }}
            >
              
              <Input
                variant="flushed"
                placeholder="Name"
                focusBorderColor="orangePeel.900"
                name={first_name}
                onChange={(e) => setFirst_name(e.target.value)}
              />
             
            </GridItem>
            <GridItem
              colSpan={{
                base: "12",
                sm: "12",
                md: "5",
              }}
            >
              <Input
                variant="flushed"
                placeholder="Email"
                focusBorderColor="orangePeel.900"
                name={email}  
                onChange={(e) => setEmail(e.target.value)}             
              />
             
            </GridItem>
            
            <GridItem
              colSpan={{
                base: "12",
                sm: "12",
                md: "2",
              }}
            >
              <AppButton onClick={() => { handleSubscription(); }}>
                Subscribe
              </AppButton>
            
            </GridItem>
          </Grid>
        </FormControl>
      </KtContainer>
    </AppSection>
  )
}

export default Subscription_form