"use client";
import React, { useState } from "react";
import { Grid, GridItem, Input,FormControl, Button } from "@chakra-ui/react";


import { AppSection, KtContainer, SectionHeading, AppButton } from "@/app/_components";
import { notFound } from "next/navigation";
import Swal from 'sweetalert2';

export default function Subscription() {
  
  const [first_name, setFirst_name] = useState("");
  const [email, setEmail] = useState(""); 
 


 const authHeaders = {
    Authorization: `Bearer ${process.env.NEXT_PUBLIC_AUTHORIZATION_KEY}`,
    'Content-Type': `application/json`
  };

const getSubscriptionInfo = async (slug) => {    
  const response = await fetch(`${process.env.NEXT_PUBLIC_KT_BRIDGE_URL}newsletter/subscribe`, {   
    headers: authHeaders,
    credentials: 'include',
    cache: "no-store",
    method: "POST",
    body: JSON.stringify(slug)
  });

  if (response.status === 404) {
    return notFound();
  }
  if (response.status === 201) {
    return response;
  }
  else{
    return response;
  }
    
};


  const handleSubscription = async() => {  
    
    if (first_name.trim() == '') {
      Swal.fire({
        icon: 'info',
        title: 'Name is required.',
      });       
      //alert("Name is required.");
      return false;         
    }  
    else if (!/^[a-zA-Z0-9\s]+$/.test(first_name)) {  
      Swal.fire({
        icon: 'error',
        title: 'Invalid name. Please use only letters, numbers, and spaces.',
      });     
      //alert("Invalid name. Please use only letters, numbers, and spaces.");
      return false;    
    }
  
    if (email.trim() == '') { 
      Swal.fire({
        icon: 'info',
        title: 'Email is required.',
      });       
       // alert("Email is required.");
        return false;  
    } else if (!/\S+@\S+\.\S+/.test(email)) {  
      Swal.fire({
        icon: 'error',
        title: 'Email is invalid.',
      });     
      // alert("Email is invalid.");
        return false;
    }     
      
      const submitData = {first_name,email}
      
   const response= await getSubscriptionInfo(submitData); 
   const data = await response.json();
   
    if (response.status == 201) {
      // Successfully submitted    
      //alert('Subscription successful');
      Swal.fire({
        icon: 'success',
        title: 'Subscription successful',
      });
      // Reset form fields after successful submission
      setFirst_name('');
      setEmail('');
    } else {
      // Handle errors
      Swal.fire({
        icon: 'error',
        title: data.message,
      });
      //alert(data.message);
      //console.error('Subscription failed:', response.statusText);
    }
}; 

  return (
    <AppSection pb="50px">
      <SectionHeading
        heading="Subscribe to our Newsletter"
        description="Sign up for Kerala Tourism's monthly newsletter to learn about our events, offers and more…"
      />
      <KtContainer maxW="container.lg">
        <FormControl>
          <Grid
            templateColumns="repeat(12, 1fr)"
            columnGap={{  base: 0, md: 4, lg: 5 }}
            rowGap={{ base: 8, md: 0}}
          >
            <GridItem
              colSpan={{
                base: "12",
                sm: "12",
                md: "5",
              }}
            >
              
              <Input
                variant="flushed"
                placeholder="Name"
                focusBorderColor="orangePeel.900"
                value={first_name}
                onChange={(e) => setFirst_name(e.target.value)}
              />
             
            </GridItem>
            <GridItem
              colSpan={{
                base: "12",
                sm: "12",
                md: "5",
              }}
            >
              <Input
                variant="flushed"
                placeholder="Email"
                focusBorderColor="orangePeel.900"
                value={email}  
                onChange={(e) => setEmail(e.target.value)}             
              />
             
            </GridItem>
            
            <GridItem
              colSpan={{
                base: "12",
                sm: "12",
                md: "2",
              }}
            >
              <AppButton onClick={() => { handleSubscription(); }}>
                Subscribe
              </AppButton>
            
            </GridItem>
          </Grid>
        </FormControl>
      </KtContainer>
    </AppSection>
  );

  
}
