"use client";

import { string, arrayOf, shape, oneOf, number } from "prop-types";
import { Box, useMediaQuery } from "@chakra-ui/react";
import {
  KtContainer,
  AppSection,
  SectionHeading,
  AppCarousel,
  EmblaContainer,
  AppLink,
} from "@/app/_components";
import {
  COMPONENT_TYPES,
  SLIDER_CATEGORIES,
} from "@/app/_constants/componentConstant";
import { isObjectEmpty } from "@/app/_utils";

const { SLIDER } = COMPONENT_TYPES;
const {
  MAIN_SLIDER,
  WHATS_NEW_SLIDER,
  VIDEO_BG_ACTIVITY_SLIDER,
  USERS_STORY_SLIDER,
  EVENT_SLIDER,
  PHOTO_GALLERY_SLIDER,
  PHOTO_VIDEO_GALLERY,
  VIDEO_GALLERY_SLIDER,
  ACTIVITY_SLIDER,
  RELATED_ACTIVITY_SLIDER,
  TOUR_GUIDE_SLIDER,
  DESTINATION_SLIDER,
  CUSTOMER_REVIEW_SLIDER,
  INFORMATION_SLIDER,
  EBROUCHURE_SLIDER,
  EBROCHURES_SLIDER,  
  PORTFOLIO_SLIDER,
  STORY_SLIDER,
  TOUR_PACKAGE_SLIDER,
  DISTRICT_SLIDER,
} = SLIDER_CATEGORIES;

import {
  carouselSectionProps,
  containerProps,
  carousalProps,
  sliderContainerProps,
  sliderItemProps,
  learnMoreBtnStyle,
  usersStoryLearnMoreBtnStyle,
} from "./_styles";

import { Main } from "./_categories";

import {
  Activity,
  CustomerReview,
  PhotoGallery,
  PhotoVideoGallery,  
  VideoGallery,
  DistrictGallery,
  RelatedActivity,
  ShareStory,
  UsersStory,
  Ebrochures,  
  VideoBgActivity,
  WhatsNew
} from "./_categories"

import {
  DefaultListItem,
  InfoCardListItem,
  PortfolioListItem,
  PackageListItem,
  TourGuide as TourGuideListItem,
} from "@/app/_components/_page/List/_categories";

export default function Slider({
  _id,
  block,
  scroll_key = "",
  heading,
  description,
  video,
  items,
  itemsPhotos={},
  itemsVideos={},  
  link = {},
  blk_style = ""
}) {
  const [isMobile] = useMediaQuery(["(max-width: 991px)"], {
    ssr: true,
    fallback: true,
  });
  
  let mystyle
    
  if(blk_style)
  {
    mystyle=blk_style.replace("display:","");
  }
  else
  {
    mystyle='block';
  }
  
  const { category } = block;

  if (category === MAIN_SLIDER) return <Main items={items} />;

  if (category === VIDEO_BG_ACTIVITY_SLIDER)
    return (
      <VideoBgActivity
        heading={heading}
        description={description}
        video={video}
        link={link}
        sectionProps={carouselSectionProps(scroll_key != "" ? scroll_key : _id)}
        items={items}
      />
    );

    const sectionId = scroll_key != "" ? scroll_key : _id;
    
    if (category === PHOTO_VIDEO_GALLERY)
      return (
        <Box
          sx={{
            display: "flex",
            flexWrap: "nowrap", // Prevent wrapping
            gap: "20px", // Optional: adds space between the sliders
            width: "100%", // Ensure the parent container takes the full width
            flexDirection: isMobile ? 'column' : 'row', // Switch layout based on screen size
          }}
        >
          <AppSection
            sx={{
              width: { xs: "100%", md: "50%" }, // Full width on small screens, half on larger
            }}
            {...carouselSectionProps(scroll_key !== "" ? scroll_key : _id)}
            explore={!isObjectEmpty(link)}
          >
            <KtContainer {...containerProps(category)}>
                      
              <Box as="article">
                <AppCarousel
                  arrowPosition = "center" arrowColor = "black"  items={itemsPhotos} {...carousalProps(category, !isObjectEmpty(link), isMobile)}
                >
                  <EmblaContainer {...sliderContainerProps(category, isMobile)}>
                    {itemsPhotos.map(({ _id, ...sliderProps }) => (
                      <Box key={_id} {...sliderItemProps(category)}>
                        {(() => {
                          return <PhotoVideoGallery {...sliderProps} itemType="photo"/>;
                        })()}
                      </Box>
                    ))}
                  </EmblaContainer>
                </AppCarousel>
              </Box>
            </KtContainer>
          </AppSection>
  
          {/* Second Slider Component */}
          <AppSection
            sx={{
              width: { xs: "100%", md: "50%" }, // Full width on small screens, half on larger
            }}
            {...carouselSectionProps(scroll_key !== "" ? scroll_key : _id)}
            explore={!isObjectEmpty(link)}
          >
            <KtContainer {...containerProps(category)}>
              
              <Box as="article">
                <AppCarousel
                  arrowPosition = "center" arrowColor = "black" items={itemsVideos} {...carousalProps(category, !isObjectEmpty(link), isMobile)}
                >
                  <EmblaContainer {...sliderContainerProps(category, isMobile)}>
                    {itemsVideos.map(({ _id, ...sliderProps }) => (
                      <Box key={_id} {...sliderItemProps(category)}>
                        {(() => {
                          return <PhotoVideoGallery {...sliderProps} itemType="video" />;
                        })()}
                      </Box>
                    ))}
                  </EmblaContainer>
                </AppCarousel>
              </Box>
            </KtContainer>
          </AppSection>
        </Box>
      );
  return (
    <AppSection style={{display:mystyle}} id={sectionId}
      {...carouselSectionProps(scroll_key != "" ? scroll_key : _id)}
      explore={!isObjectEmpty(link)}
      // sectionHeading={typeof heading === "string"}
      
      {...items}
      
    >
      <KtContainer {...containerProps(category)} >
        {(heading || description) && (
          <Box maxW="container.xl" mx="auto">
            <SectionHeading
              heading={heading}
              description={description}
              slider={category === WHATS_NEW_SLIDER}
            />
          </Box>
        )}
        <Box as="article">
          <AppCarousel
            {...carousalProps(category, !isObjectEmpty(link), isMobile)}  items={items}
          >
            <EmblaContainer {...sliderContainerProps(category, isMobile)} >
              {items.map(({ _id, ...sliderProps }) => (
                <Box key={_id} {...sliderItemProps(category)}>
                  {(() => {
                    switch (category) {
                      case ACTIVITY_SLIDER:
                        return <Activity {...sliderProps} />;             
                      case RELATED_ACTIVITY_SLIDER:
                        return <RelatedActivity {...sliderProps} />;
                        case DISTRICT_SLIDER:
                          return <DistrictGallery {...sliderProps} />;
                      case PHOTO_GALLERY_SLIDER:
                        return <PhotoGallery {...sliderProps} />;
                      case VIDEO_GALLERY_SLIDER:
                        return <VideoGallery {...sliderProps} />;                        
                      case DESTINATION_SLIDER:
                        return (
                          <DefaultListItem {...sliderProps} showType="large" />
                        );
                      case WHATS_NEW_SLIDER:
                        return <WhatsNew {...sliderProps} />;
                      case EVENT_SLIDER:
                        return (
                          <DefaultListItem {...sliderProps} showType="large" category="event"/>
                        );
                      case EBROUCHURE_SLIDER:
                        return (
                          <DefaultListItem {...sliderProps} showType="medium" />
                        );
                      case EBROCHURES_SLIDER:
                        return (
                          <Ebrochures {...sliderProps} />
                        );                          
                      case STORY_SLIDER:
                        return (
                          <DefaultListItem {...sliderProps} showType="medium" />
                        );
                      case USERS_STORY_SLIDER:
                        return <UsersStory {...sliderProps} />;
                      case TOUR_GUIDE_SLIDER:
                        return <TourGuideListItem {...sliderProps} />;
                      case INFORMATION_SLIDER:
                        return <InfoCardListItem {...sliderProps} />;
                      case CUSTOMER_REVIEW_SLIDER:
                        return <CustomerReview {...sliderProps} />;
                      case PORTFOLIO_SLIDER:
                        return <PortfolioListItem {...sliderProps} />;
                      case TOUR_PACKAGE_SLIDER:
                        return <PackageListItem {...sliderProps} />;
                      default:
                        return null;
                    }
                  })()}
                </Box>
              ))}
            </EmblaContainer>
          </AppCarousel>
          {/* Share Story Block */}
          {/*  {category === USERS_STORY_SLIDER && (
            <ShareStory link={!isObjectEmpty(link)} />
          )}  */}
        </Box>

        {/* Explore Btn for Sliders except Story Slider */}
        {!isObjectEmpty(link) && category !== USERS_STORY_SLIDER && category !== EBROCHURES_SLIDER && (
          <Box as="div" {...learnMoreBtnStyle}>
            <AppLink
              title={link.title}
              parent={link.parent}
              slug={link.slug}
              type={link.type}
              variant="pill"
              color="black"
              arrow
            >
              {link.text}
            </AppLink>
          </Box>
        )}
      </KtContainer>

      {/*  Explore Btn for Story Slider */}
      {!isObjectEmpty(link) && (category === USERS_STORY_SLIDER || category === EBROCHURES_SLIDER) && (
        <Box as="div" {...usersStoryLearnMoreBtnStyle}>
          <AppLink
            title={link.title}
            parent={link.parent}
            slug={link.slug}
            type={link.type}
            variant="pill"
            color="black"
            arrow
          >
            {link.text}
          </AppLink>
        </Box>
      )}
    </AppSection>
  );
}

Slider.propTypes = {
  _id: string.isRequired,
  block: shape({
    type: oneOf([SLIDER]),
    category: oneOf([
      MAIN_SLIDER,
      WHATS_NEW_SLIDER,
      VIDEO_BG_ACTIVITY_SLIDER,
      USERS_STORY_SLIDER,
      EVENT_SLIDER,
      PHOTO_GALLERY_SLIDER,
      PHOTO_VIDEO_GALLERY,
      VIDEO_GALLERY_SLIDER,
      ACTIVITY_SLIDER,
      RELATED_ACTIVITY_SLIDER,
      TOUR_GUIDE_SLIDER,
      DESTINATION_SLIDER,
      CUSTOMER_REVIEW_SLIDER,
      INFORMATION_SLIDER,
      EBROUCHURE_SLIDER,
      EBROCHURES_SLIDER,
      PORTFOLIO_SLIDER,
      STORY_SLIDER,
      TOUR_PACKAGE_SLIDER,
    ]),
  }).isRequired,
  heading: string,
  description: string,
  scroll_key: string,
  video: shape({
    desktop_url: string,
    mobile_url: string,
  }),
  items: arrayOf(
    shape({
      _id: string.isRequired,
      heading: string,
      description: string,
      fromDate: string,
      contact_num: string,
      image: shape({
        url: string.isRequired,
        alt: string.isRequired,
      }),
      video: shape({
        desktop: shape({
          url: string.isRequired,
          poster_image: string.isRequired,
        }),
        mobile: shape({
          url: string.isRequired,
          poster_image: string.isRequired,
        }),
      }),
      uploaded_video: shape({
        type: string.isRequired,
        title: string.isRequired,
        url: string.isRequired,
      }),
      author: shape({
        image: string.isRequired,
        name: string.isRequired,
        profile: string,
      }),
      guide_info: shape({
        image: string.isRequired,
        name: string.isRequired,
        agency: string.isRequired,
        contact_num: string.isRequired,
        rating: number.isRequired,
      }),
      link: shape({
        title: string.isRequired,
        text: string.isRequired,
        type: string.isRequired,
        parent: string.isRequired,
        slug: string,
      }),
    })
  ),
  link: shape({
    title: string,
    text: string,
    type: string,
    parent: string,
    slug: string,
  }),
};
