import {
  Box,
  Grid,
  Flex,
  Text,
  Button,
  Divider,
  useMediaQuery,
} from "@chakra-ui/react";
import { BsPlus } from "react-icons/bs";

import { KtHeading } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";
import { pxToRem } from "@/app/_utils";
import { useDispatchContext } from "@/app/_context";

export default function ShareStory({ link }) {
  const [isMobile] = useMediaQuery("(max-width: 767px)", { ssr: true });
  
  const dispatch = useDispatchContext();
  return (
    <Grid
      templateColumns={{
        base: "repeat(1, 1fr)",
        lg: "repeat(2, 1fr)",
      }}
      placeContent="center"
      py={{
        base: 8,
        md: 10,
      }}
      gap={0}
      {...(!link && {
        mt: {
          base: 8,
          lg: 0,
        },
      })}
      bg="antiFlashWhite"
    >
      <Flex
        alignItems="center"
        gap={{
          base: 0,
          lg: 20,
        }}
        justify={{
          base: "center",
          lg: "flex-end",
        }}
        textAlign={{
          base: "center",
          lg: "initial",
        }}
      >
        <KtHeading as="h4" color="black">
          Share your <br /> Kerala experience
        </KtHeading>
        {!isMobile && (
          <Divider
            orientation="vertical"
            borderLeftWidth={1}
            borderColor="gray"
            height={{
              lg: "80px",
            }}
            opacity={1}
            right="0"
          />
        )}
      </Flex>

      <Box
        pl={{
          base: pxToRem(0),
          sm: pxToRem(0),
          lg: pxToRem(80),
        }}
        textAlign={{
          base: "center",
          lg: "initial",
        }}
      >
        <Text as="p" mb={4} fontSize={appTextFontSize}>
          Had a trip of your lifetime in Kerala? Share <br /> your story with us
          and get featured here.
        </Text>
        <Button
          size="md"
          variant="outline"
          width="200px"
          borderRadius="full"
          borderColor="black"
          transition=".5s linear"
          _hover={{
            borderColor: "orangePeel.900",
            "& svg": {
              fontSize: "40",
              "> path": {
                fill: "orangePeel.900",
              },
            },
          }}
          onClick={() => dispatch({ type: "HANDLE_SIGNUP_MODAL", value: true })}
          rightIcon={<BsPlus fontSize={30} />}
          fontSize={appTextFontSize}
        >
          Publish your trip
        </Button>
      </Box>
    </Grid>
  );
}
